/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ApprovalResult;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutApprovalResultRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutApprovalResultRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String actionName;
    private final ApprovalResult result;
    private final String token;

    private PutApprovalResultRequest(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.result = builder.result;
        this.token = builder.token;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String actionName() {
        return this.actionName;
    }

    public ApprovalResult result() {
        return this.result;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.actionName() == null ? 0 : this.actionName().hashCode());
        hashCode = 31 * hashCode + (this.result() == null ? 0 : this.result().hashCode());
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApprovalResultRequest)) {
            return false;
        }
        PutApprovalResultRequest other = (PutApprovalResultRequest)((Object)obj);
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.actionName() == null ^ this.actionName() == null) {
            return false;
        }
        if (other.actionName() != null && !other.actionName().equals(this.actionName())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        return other.token() == null || other.token().equals(this.token());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.actionName() != null) {
            sb.append("ActionName: ").append(this.actionName()).append(",");
        }
        if (this.result() != null) {
            sb.append("Result: ").append(this.result()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "actionName": {
                return Optional.of(clazz.cast(this.actionName()));
            }
            case "result": {
                return Optional.of(clazz.cast(this.result()));
            }
            case "token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String actionName;
        private ApprovalResult result;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApprovalResultRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.actionName(model.actionName);
            this.result(model.result);
            this.token(model.token);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ApprovalResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        @Override
        public final Builder result(ApprovalResult result) {
            this.result = result;
            return this;
        }

        public final void setResult(ApprovalResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public PutApprovalResultRequest build() {
            return new PutApprovalResultRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutApprovalResultRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder actionName(String var1);

        public Builder result(ApprovalResult var1);

        public Builder token(String var1);
    }
}

