/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FailureType {
    JOB_FAILED("JobFailed"),
    CONFIGURATION_ERROR("ConfigurationError"),
    PERMISSION_ERROR("PermissionError"),
    REVISION_OUT_OFSYNC("RevisionOutOfSync"),
    REVISION_UNAVAILABLE("RevisionUnavailable"),
    SYSTEM_UNAVAILABLE("SystemUnavailable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FailureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FailureType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureType> knownValues() {
        return Stream.of(FailureType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

