/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.StageTransitionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableStageTransitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableStageTransitionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String transitionType;

    private EnableStageTransitionRequest(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.transitionType = builder.transitionType;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public StageTransitionType transitionType() {
        return StageTransitionType.fromValue(this.transitionType);
    }

    public String transitionTypeString() {
        return this.transitionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.transitionTypeString() == null ? 0 : this.transitionTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableStageTransitionRequest)) {
            return false;
        }
        EnableStageTransitionRequest other = (EnableStageTransitionRequest)((Object)obj);
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.transitionTypeString() == null ^ this.transitionTypeString() == null) {
            return false;
        }
        return other.transitionTypeString() == null || other.transitionTypeString().equals(this.transitionTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.transitionTypeString() != null) {
            sb.append("TransitionType: ").append(this.transitionTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "transitionType": {
                return Optional.of(clazz.cast(this.transitionTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String transitionType;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableStageTransitionRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.transitionType(model.transitionType);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getTransitionType() {
            return this.transitionType;
        }

        @Override
        public final Builder transitionType(String transitionType) {
            this.transitionType = transitionType;
            return this;
        }

        @Override
        public final Builder transitionType(StageTransitionType transitionType) {
            this.transitionType(transitionType.toString());
            return this;
        }

        public final void setTransitionType(String transitionType) {
            this.transitionType = transitionType;
        }

        public EnableStageTransitionRequest build() {
            return new EnableStageTransitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableStageTransitionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder transitionType(String var1);

        public Builder transitionType(StageTransitionType var1);
    }
}

