/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus;
import software.amazon.awssdk.services.codepipeline.model.ErrorDetails;
import software.amazon.awssdk.services.codepipeline.transform.ActionExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionExecution> {
    private final String status;
    private final String summary;
    private final Instant lastStatusChange;
    private final String token;
    private final String lastUpdatedBy;
    private final String externalExecutionId;
    private final String externalExecutionUrl;
    private final Integer percentComplete;
    private final ErrorDetails errorDetails;

    private ActionExecution(BuilderImpl builder) {
        this.status = builder.status;
        this.summary = builder.summary;
        this.lastStatusChange = builder.lastStatusChange;
        this.token = builder.token;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionUrl = builder.externalExecutionUrl;
        this.percentComplete = builder.percentComplete;
        this.errorDetails = builder.errorDetails;
    }

    public ActionExecutionStatus status() {
        return ActionExecutionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String summary() {
        return this.summary;
    }

    public Instant lastStatusChange() {
        return this.lastStatusChange;
    }

    public String token() {
        return this.token;
    }

    public String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String externalExecutionId() {
        return this.externalExecutionId;
    }

    public String externalExecutionUrl() {
        return this.externalExecutionUrl;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.summary() == null ? 0 : this.summary().hashCode());
        hashCode = 31 * hashCode + (this.lastStatusChange() == null ? 0 : this.lastStatusChange().hashCode());
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedBy() == null ? 0 : this.lastUpdatedBy().hashCode());
        hashCode = 31 * hashCode + (this.externalExecutionId() == null ? 0 : this.externalExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.externalExecutionUrl() == null ? 0 : this.externalExecutionUrl().hashCode());
        hashCode = 31 * hashCode + (this.percentComplete() == null ? 0 : this.percentComplete().hashCode());
        hashCode = 31 * hashCode + (this.errorDetails() == null ? 0 : this.errorDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecution)) {
            return false;
        }
        ActionExecution other = (ActionExecution)obj;
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.summary() == null ^ this.summary() == null) {
            return false;
        }
        if (other.summary() != null && !other.summary().equals(this.summary())) {
            return false;
        }
        if (other.lastStatusChange() == null ^ this.lastStatusChange() == null) {
            return false;
        }
        if (other.lastStatusChange() != null && !other.lastStatusChange().equals(this.lastStatusChange())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        if (other.token() != null && !other.token().equals(this.token())) {
            return false;
        }
        if (other.lastUpdatedBy() == null ^ this.lastUpdatedBy() == null) {
            return false;
        }
        if (other.lastUpdatedBy() != null && !other.lastUpdatedBy().equals(this.lastUpdatedBy())) {
            return false;
        }
        if (other.externalExecutionId() == null ^ this.externalExecutionId() == null) {
            return false;
        }
        if (other.externalExecutionId() != null && !other.externalExecutionId().equals(this.externalExecutionId())) {
            return false;
        }
        if (other.externalExecutionUrl() == null ^ this.externalExecutionUrl() == null) {
            return false;
        }
        if (other.externalExecutionUrl() != null && !other.externalExecutionUrl().equals(this.externalExecutionUrl())) {
            return false;
        }
        if (other.percentComplete() == null ^ this.percentComplete() == null) {
            return false;
        }
        if (other.percentComplete() != null && !other.percentComplete().equals(this.percentComplete())) {
            return false;
        }
        if (other.errorDetails() == null ^ this.errorDetails() == null) {
            return false;
        }
        return other.errorDetails() == null || other.errorDetails().equals(this.errorDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.summary() != null) {
            sb.append("Summary: ").append(this.summary()).append(",");
        }
        if (this.lastStatusChange() != null) {
            sb.append("LastStatusChange: ").append(this.lastStatusChange()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (this.lastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.lastUpdatedBy()).append(",");
        }
        if (this.externalExecutionId() != null) {
            sb.append("ExternalExecutionId: ").append(this.externalExecutionId()).append(",");
        }
        if (this.externalExecutionUrl() != null) {
            sb.append("ExternalExecutionUrl: ").append(this.externalExecutionUrl()).append(",");
        }
        if (this.percentComplete() != null) {
            sb.append("PercentComplete: ").append(this.percentComplete()).append(",");
        }
        if (this.errorDetails() != null) {
            sb.append("ErrorDetails: ").append(this.errorDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "summary": {
                return Optional.of(clazz.cast(this.summary()));
            }
            case "lastStatusChange": {
                return Optional.of(clazz.cast(this.lastStatusChange()));
            }
            case "token": {
                return Optional.of(clazz.cast(this.token()));
            }
            case "lastUpdatedBy": {
                return Optional.of(clazz.cast(this.lastUpdatedBy()));
            }
            case "externalExecutionId": {
                return Optional.of(clazz.cast(this.externalExecutionId()));
            }
            case "externalExecutionUrl": {
                return Optional.of(clazz.cast(this.externalExecutionUrl()));
            }
            case "percentComplete": {
                return Optional.of(clazz.cast(this.percentComplete()));
            }
            case "errorDetails": {
                return Optional.of(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String summary;
        private Instant lastStatusChange;
        private String token;
        private String lastUpdatedBy;
        private String externalExecutionId;
        private String externalExecutionUrl;
        private Integer percentComplete;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecution model) {
            this.status(model.status);
            this.summary(model.summary);
            this.lastStatusChange(model.lastStatusChange);
            this.token(model.token);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.externalExecutionId(model.externalExecutionId);
            this.externalExecutionUrl(model.externalExecutionUrl);
            this.percentComplete(model.percentComplete);
            this.errorDetails(model.errorDetails);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final Instant getLastStatusChange() {
            return this.lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public final String getExternalExecutionUrl() {
            return this.externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        public final Integer getPercentComplete() {
            return this.percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        public ActionExecution build() {
            return new ActionExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionExecution> {
        public Builder status(String var1);

        public Builder status(ActionExecutionStatus var1);

        public Builder summary(String var1);

        public Builder lastStatusChange(Instant var1);

        public Builder token(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder externalExecutionId(String var1);

        public Builder externalExecutionUrl(String var1);

        public Builder percentComplete(Integer var1);

        public Builder errorDetails(ErrorDetails var1);
    }
}

