/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobData;

@SdkInternalApi
public class ThirdPartyJobDataMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACTIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionTypeId").build();
    private static final MarshallingInfo<StructuredPojo> ACTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> PIPELINECONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineContext").build();
    private static final MarshallingInfo<List> INPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputArtifacts").build();
    private static final MarshallingInfo<List> OUTPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputArtifacts").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactCredentials").build();
    private static final MarshallingInfo<String> CONTINUATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("continuationToken").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKey").build();
    private static final ThirdPartyJobDataMarshaller INSTANCE = new ThirdPartyJobDataMarshaller();

    public static ThirdPartyJobDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThirdPartyJobData thirdPartyJobData, ProtocolMarshaller protocolMarshaller) {
        if (thirdPartyJobData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)thirdPartyJobData.actionTypeId(), ACTIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)thirdPartyJobData.actionConfiguration(), ACTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)thirdPartyJobData.pipelineContext(), PIPELINECONTEXT_BINDING);
            protocolMarshaller.marshall(thirdPartyJobData.inputArtifacts(), INPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall(thirdPartyJobData.outputArtifacts(), OUTPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)thirdPartyJobData.artifactCredentials(), ARTIFACTCREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)thirdPartyJobData.continuationToken(), CONTINUATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)thirdPartyJobData.encryptionKey(), ENCRYPTIONKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

