/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials;
import software.amazon.awssdk.services.codepipeline.model.ActionConfiguration;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.Artifact;
import software.amazon.awssdk.services.codepipeline.model.ArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.model.EncryptionKey;
import software.amazon.awssdk.services.codepipeline.model.PipelineContext;
import software.amazon.awssdk.services.codepipeline.transform.JobDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobData
implements StructuredPojo,
ToCopyableBuilder<Builder, JobData> {
    private final ActionTypeId actionTypeId;
    private final ActionConfiguration actionConfiguration;
    private final PipelineContext pipelineContext;
    private final List<Artifact> inputArtifacts;
    private final List<Artifact> outputArtifacts;
    private final AWSSessionCredentials artifactCredentials;
    private final String continuationToken;
    private final EncryptionKey encryptionKey;

    private JobData(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.actionConfiguration = builder.actionConfiguration;
        this.pipelineContext = builder.pipelineContext;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.artifactCredentials = builder.artifactCredentials;
        this.continuationToken = builder.continuationToken;
        this.encryptionKey = builder.encryptionKey;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public ActionConfiguration actionConfiguration() {
        return this.actionConfiguration;
    }

    public PipelineContext pipelineContext() {
        return this.pipelineContext;
    }

    public List<Artifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public List<Artifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public AWSSessionCredentials artifactCredentials() {
        return this.artifactCredentials;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public EncryptionKey encryptionKey() {
        return this.encryptionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionTypeId() == null ? 0 : this.actionTypeId().hashCode());
        hashCode = 31 * hashCode + (this.actionConfiguration() == null ? 0 : this.actionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.pipelineContext() == null ? 0 : this.pipelineContext().hashCode());
        hashCode = 31 * hashCode + (this.inputArtifacts() == null ? 0 : this.inputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.outputArtifacts() == null ? 0 : this.outputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.artifactCredentials() == null ? 0 : this.artifactCredentials().hashCode());
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        hashCode = 31 * hashCode + (this.encryptionKey() == null ? 0 : this.encryptionKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobData)) {
            return false;
        }
        JobData other = (JobData)obj;
        if (other.actionTypeId() == null ^ this.actionTypeId() == null) {
            return false;
        }
        if (other.actionTypeId() != null && !other.actionTypeId().equals(this.actionTypeId())) {
            return false;
        }
        if (other.actionConfiguration() == null ^ this.actionConfiguration() == null) {
            return false;
        }
        if (other.actionConfiguration() != null && !other.actionConfiguration().equals(this.actionConfiguration())) {
            return false;
        }
        if (other.pipelineContext() == null ^ this.pipelineContext() == null) {
            return false;
        }
        if (other.pipelineContext() != null && !other.pipelineContext().equals(this.pipelineContext())) {
            return false;
        }
        if (other.inputArtifacts() == null ^ this.inputArtifacts() == null) {
            return false;
        }
        if (other.inputArtifacts() != null && !other.inputArtifacts().equals(this.inputArtifacts())) {
            return false;
        }
        if (other.outputArtifacts() == null ^ this.outputArtifacts() == null) {
            return false;
        }
        if (other.outputArtifacts() != null && !other.outputArtifacts().equals(this.outputArtifacts())) {
            return false;
        }
        if (other.artifactCredentials() == null ^ this.artifactCredentials() == null) {
            return false;
        }
        if (other.artifactCredentials() != null && !other.artifactCredentials().equals(this.artifactCredentials())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.encryptionKey() == null ^ this.encryptionKey() == null) {
            return false;
        }
        return other.encryptionKey() == null || other.encryptionKey().equals(this.encryptionKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actionTypeId() != null) {
            sb.append("ActionTypeId: ").append(this.actionTypeId()).append(",");
        }
        if (this.actionConfiguration() != null) {
            sb.append("ActionConfiguration: ").append(this.actionConfiguration()).append(",");
        }
        if (this.pipelineContext() != null) {
            sb.append("PipelineContext: ").append(this.pipelineContext()).append(",");
        }
        if (this.inputArtifacts() != null) {
            sb.append("InputArtifacts: ").append(this.inputArtifacts()).append(",");
        }
        if (this.outputArtifacts() != null) {
            sb.append("OutputArtifacts: ").append(this.outputArtifacts()).append(",");
        }
        if (this.artifactCredentials() != null) {
            sb.append("ArtifactCredentials: ").append(this.artifactCredentials()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.encryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.encryptionKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private ActionConfiguration actionConfiguration;
        private PipelineContext pipelineContext;
        private List<Artifact> inputArtifacts;
        private List<Artifact> outputArtifacts;
        private AWSSessionCredentials artifactCredentials;
        private String continuationToken;
        private EncryptionKey encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(JobData model) {
            this.setActionTypeId(model.actionTypeId);
            this.setActionConfiguration(model.actionConfiguration);
            this.setPipelineContext(model.pipelineContext);
            this.setInputArtifacts(model.inputArtifacts);
            this.setOutputArtifacts(model.outputArtifacts);
            this.setArtifactCredentials(model.artifactCredentials);
            this.setContinuationToken(model.continuationToken);
            this.setEncryptionKey(model.encryptionKey);
        }

        public final ActionTypeId getActionTypeId() {
            return this.actionTypeId;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
        }

        public final ActionConfiguration getActionConfiguration() {
            return this.actionConfiguration;
        }

        @Override
        public final Builder actionConfiguration(ActionConfiguration actionConfiguration) {
            this.actionConfiguration = actionConfiguration;
            return this;
        }

        public final void setActionConfiguration(ActionConfiguration actionConfiguration) {
            this.actionConfiguration = actionConfiguration;
        }

        public final PipelineContext getPipelineContext() {
            return this.pipelineContext;
        }

        @Override
        public final Builder pipelineContext(PipelineContext pipelineContext) {
            this.pipelineContext = pipelineContext;
            return this;
        }

        public final void setPipelineContext(PipelineContext pipelineContext) {
            this.pipelineContext = pipelineContext;
        }

        public final Collection<Artifact> getInputArtifacts() {
            return this.inputArtifacts;
        }

        @Override
        public final Builder inputArtifacts(Collection<Artifact> inputArtifacts) {
            this.inputArtifacts = ArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Artifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        public final void setInputArtifacts(Collection<Artifact> inputArtifacts) {
            this.inputArtifacts = ArtifactListCopier.copy(inputArtifacts);
        }

        @SafeVarargs
        public final void setInputArtifacts(Artifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
        }

        public final Collection<Artifact> getOutputArtifacts() {
            return this.outputArtifacts;
        }

        @Override
        public final Builder outputArtifacts(Collection<Artifact> outputArtifacts) {
            this.outputArtifacts = ArtifactListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Artifact ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        public final void setOutputArtifacts(Collection<Artifact> outputArtifacts) {
            this.outputArtifacts = ArtifactListCopier.copy(outputArtifacts);
        }

        @SafeVarargs
        public final void setOutputArtifacts(Artifact ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
        }

        public final AWSSessionCredentials getArtifactCredentials() {
            return this.artifactCredentials;
        }

        @Override
        public final Builder artifactCredentials(AWSSessionCredentials artifactCredentials) {
            this.artifactCredentials = artifactCredentials;
            return this;
        }

        public final void setArtifactCredentials(AWSSessionCredentials artifactCredentials) {
            this.artifactCredentials = artifactCredentials;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final EncryptionKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public JobData build() {
            return new JobData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobData> {
        public Builder actionTypeId(ActionTypeId var1);

        public Builder actionConfiguration(ActionConfiguration var1);

        public Builder pipelineContext(PipelineContext var1);

        public Builder inputArtifacts(Collection<Artifact> var1);

        public Builder inputArtifacts(Artifact ... var1);

        public Builder outputArtifacts(Collection<Artifact> var1);

        public Builder outputArtifacts(Artifact ... var1);

        public Builder artifactCredentials(AWSSessionCredentials var1);

        public Builder continuationToken(String var1);

        public Builder encryptionKey(EncryptionKey var1);
    }
}

