/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RetryStageExecutionRequestModelMarshaller {
    private static final MarshallingInfo<String> PIPELINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineName").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").isBinary(false).build();
    private static final MarshallingInfo<String> PIPELINEEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> RETRYMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryMode").isBinary(false).build();
    private static final RetryStageExecutionRequestModelMarshaller INSTANCE = new RetryStageExecutionRequestModelMarshaller();

    private RetryStageExecutionRequestModelMarshaller() {
    }

    public static RetryStageExecutionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RetryStageExecutionRequest retryStageExecutionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)retryStageExecutionRequest), (String)"retryStageExecutionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)retryStageExecutionRequest.pipelineName(), PIPELINENAME_BINDING);
            protocolMarshaller.marshall((Object)retryStageExecutionRequest.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)retryStageExecutionRequest.pipelineExecutionId(), PIPELINEEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)retryStageExecutionRequest.retryModeAsString(), RETRYMODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

