/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest;
import software.amazon.awssdk.services.codepipeline.transform.PutWebhookRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutWebhookRequestMarshaller
implements Marshaller<Request<PutWebhookRequest>, PutWebhookRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("CodePipeline_20150709.PutWebhook").serviceName("CodePipeline").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public PutWebhookRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutWebhookRequest> marshall(PutWebhookRequest putWebhookRequest) {
        Validate.paramNotNull((Object)((Object)putWebhookRequest), (String)"putWebhookRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)putWebhookRequest);
            protocolMarshaller.startMarshalling();
            PutWebhookRequestModelMarshaller.getInstance().marshall(putWebhookRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

