/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.JobData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobDataMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACTIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionTypeId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PIPELINECONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineContext").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputArtifacts").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputArtifacts").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactCredentials").isBinary(false).build();
    private static final MarshallingInfo<String> CONTINUATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("continuationToken").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKey").isBinary(false).build();
    private static final JobDataMarshaller INSTANCE = new JobDataMarshaller();

    private JobDataMarshaller() {
    }

    public static JobDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobData jobData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobData, (String)"jobData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobData.actionTypeId(), ACTIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)jobData.actionConfiguration(), ACTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)jobData.pipelineContext(), PIPELINECONTEXT_BINDING);
            protocolMarshaller.marshall(jobData.inputArtifacts(), INPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall(jobData.outputArtifacts(), OUTPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)jobData.artifactCredentials(), ARTIFACTCREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)jobData.continuationToken(), CONTINUATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)jobData.encryptionKey(), ENCRYPTIONKEY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

