/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyType;
import software.amazon.awssdk.services.codepipeline.transform.ActionConfigurationPropertyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionConfigurationProperty
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionConfigurationProperty> {
    private final String name;
    private final Boolean required;
    private final Boolean key;
    private final Boolean secret;
    private final Boolean queryable;
    private final String description;
    private final String type;

    private ActionConfigurationProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.key = builder.key;
        this.secret = builder.secret;
        this.queryable = builder.queryable;
        this.description = builder.description;
        this.type = builder.type;
    }

    public String name() {
        return this.name;
    }

    public Boolean required() {
        return this.required;
    }

    public Boolean key() {
        return this.key;
    }

    public Boolean secret() {
        return this.secret;
    }

    public Boolean queryable() {
        return this.queryable;
    }

    public String description() {
        return this.description;
    }

    public ActionConfigurationPropertyType type() {
        return ActionConfigurationPropertyType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryable());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionConfigurationProperty)) {
            return false;
        }
        ActionConfigurationProperty other = (ActionConfigurationProperty)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.secret(), other.secret()) && Objects.equals(this.queryable(), other.queryable()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ActionConfigurationProperty").add("Name", (Object)this.name()).add("Required", (Object)this.required()).add("Key", (Object)this.key()).add("Secret", (Object)this.secret()).add("Queryable", (Object)this.queryable()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "required": {
                return Optional.of(clazz.cast(this.required()));
            }
            case "key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "secret": {
                return Optional.of(clazz.cast(this.secret()));
            }
            case "queryable": {
                return Optional.of(clazz.cast(this.queryable()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionConfigurationPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean required;
        private Boolean key;
        private Boolean secret;
        private Boolean queryable;
        private String description;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionConfigurationProperty model) {
            this.name(model.name);
            this.required(model.required);
            this.key(model.key);
            this.secret(model.secret);
            this.queryable(model.queryable);
            this.description(model.description);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        public final Boolean getKey() {
            return this.key;
        }

        @Override
        public final Builder key(Boolean key) {
            this.key = key;
            return this;
        }

        public final void setKey(Boolean key) {
            this.key = key;
        }

        public final Boolean getSecret() {
            return this.secret;
        }

        @Override
        public final Builder secret(Boolean secret) {
            this.secret = secret;
            return this;
        }

        public final void setSecret(Boolean secret) {
            this.secret = secret;
        }

        public final Boolean getQueryable() {
            return this.queryable;
        }

        @Override
        public final Builder queryable(Boolean queryable) {
            this.queryable = queryable;
            return this;
        }

        public final void setQueryable(Boolean queryable) {
            this.queryable = queryable;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionConfigurationPropertyType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public ActionConfigurationProperty build() {
            return new ActionConfigurationProperty(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionConfigurationProperty> {
        public Builder name(String var1);

        public Builder required(Boolean var1);

        public Builder key(Boolean var1);

        public Builder secret(Boolean var1);

        public Builder queryable(Boolean var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(ActionConfigurationPropertyType var1);
    }
}

