/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationMapCopier;
import software.amazon.awssdk.services.codepipeline.transform.ActionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionConfiguration> {
    private final Map<String, String> configuration;

    private ActionConfiguration(BuilderImpl builder) {
        this.configuration = builder.configuration;
    }

    public Map<String, String> configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionConfiguration)) {
            return false;
        }
        ActionConfiguration other = (ActionConfiguration)obj;
        return Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"ActionConfiguration").add("Configuration", this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionConfiguration model) {
            this.configuration(model.configuration);
        }

        public final Map<String, String> getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        public ActionConfiguration build() {
            return new ActionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionConfiguration> {
        public Builder configuration(Map<String, String> var1);
    }
}

