/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionState;
import software.amazon.awssdk.services.codepipeline.model.ActionStateListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageExecution;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;
import software.amazon.awssdk.services.codepipeline.transform.StageStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StageState
implements StructuredPojo,
ToCopyableBuilder<Builder, StageState> {
    private final String stageName;
    private final TransitionState inboundTransitionState;
    private final List<ActionState> actionStates;
    private final StageExecution latestExecution;

    private StageState(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.inboundTransitionState = builder.inboundTransitionState;
        this.actionStates = builder.actionStates;
        this.latestExecution = builder.latestExecution;
    }

    public String stageName() {
        return this.stageName;
    }

    public TransitionState inboundTransitionState() {
        return this.inboundTransitionState;
    }

    public List<ActionState> actionStates() {
        return this.actionStates;
    }

    public StageExecution latestExecution() {
        return this.latestExecution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.inboundTransitionState() == null ? 0 : this.inboundTransitionState().hashCode());
        hashCode = 31 * hashCode + (this.actionStates() == null ? 0 : this.actionStates().hashCode());
        hashCode = 31 * hashCode + (this.latestExecution() == null ? 0 : this.latestExecution().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState)obj;
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.inboundTransitionState() == null ^ this.inboundTransitionState() == null) {
            return false;
        }
        if (other.inboundTransitionState() != null && !other.inboundTransitionState().equals(this.inboundTransitionState())) {
            return false;
        }
        if (other.actionStates() == null ^ this.actionStates() == null) {
            return false;
        }
        if (other.actionStates() != null && !other.actionStates().equals(this.actionStates())) {
            return false;
        }
        if (other.latestExecution() == null ^ this.latestExecution() == null) {
            return false;
        }
        return other.latestExecution() == null || other.latestExecution().equals(this.latestExecution());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.inboundTransitionState() != null) {
            sb.append("InboundTransitionState: ").append(this.inboundTransitionState()).append(",");
        }
        if (this.actionStates() != null) {
            sb.append("ActionStates: ").append(this.actionStates()).append(",");
        }
        if (this.latestExecution() != null) {
            sb.append("LatestExecution: ").append(this.latestExecution()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String stageName;
        private TransitionState inboundTransitionState;
        private List<ActionState> actionStates;
        private StageExecution latestExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(StageState model) {
            this.setStageName(model.stageName);
            this.setInboundTransitionState(model.inboundTransitionState);
            this.setActionStates(model.actionStates);
            this.setLatestExecution(model.latestExecution);
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final TransitionState getInboundTransitionState() {
            return this.inboundTransitionState;
        }

        @Override
        public final Builder inboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
            return this;
        }

        public final void setInboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
        }

        public final Collection<ActionState> getActionStates() {
            return this.actionStates;
        }

        @Override
        public final Builder actionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(ActionState ... actionStates) {
            if (this.actionStates == null) {
                this.actionStates = new ArrayList<ActionState>(actionStates.length);
            }
            for (ActionState e : actionStates) {
                this.actionStates.add(e);
            }
            return this;
        }

        public final void setActionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
        }

        @SafeVarargs
        public final void setActionStates(ActionState ... actionStates) {
            if (this.actionStates == null) {
                this.actionStates = new ArrayList<ActionState>(actionStates.length);
            }
            for (ActionState e : actionStates) {
                this.actionStates.add(e);
            }
        }

        public final StageExecution getLatestExecution() {
            return this.latestExecution;
        }

        @Override
        public final Builder latestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final void setLatestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
        }

        public StageState build() {
            return new StageState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StageState> {
        public Builder stageName(String var1);

        public Builder inboundTransitionState(TransitionState var1);

        public Builder actionStates(Collection<ActionState> var1);

        public Builder actionStates(ActionState ... var1);

        public Builder latestExecution(StageExecution var1);
    }
}

