/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus;
import software.amazon.awssdk.services.codepipeline.model.ErrorDetails;
import software.amazon.awssdk.services.codepipeline.transform.ActionExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionExecution> {
    private final String status;
    private final String summary;
    private final Date lastStatusChange;
    private final String token;
    private final String lastUpdatedBy;
    private final String externalExecutionId;
    private final String externalExecutionUrl;
    private final Integer percentComplete;
    private final ErrorDetails errorDetails;

    private ActionExecution(BuilderImpl builder) {
        this.status = builder.status;
        this.summary = builder.summary;
        this.lastStatusChange = builder.lastStatusChange;
        this.token = builder.token;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionUrl = builder.externalExecutionUrl;
        this.percentComplete = builder.percentComplete;
        this.errorDetails = builder.errorDetails;
    }

    public String status() {
        return this.status;
    }

    public String summary() {
        return this.summary;
    }

    public Date lastStatusChange() {
        return this.lastStatusChange;
    }

    public String token() {
        return this.token;
    }

    public String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String externalExecutionId() {
        return this.externalExecutionId;
    }

    public String externalExecutionUrl() {
        return this.externalExecutionUrl;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.summary() == null ? 0 : this.summary().hashCode());
        hashCode = 31 * hashCode + (this.lastStatusChange() == null ? 0 : this.lastStatusChange().hashCode());
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedBy() == null ? 0 : this.lastUpdatedBy().hashCode());
        hashCode = 31 * hashCode + (this.externalExecutionId() == null ? 0 : this.externalExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.externalExecutionUrl() == null ? 0 : this.externalExecutionUrl().hashCode());
        hashCode = 31 * hashCode + (this.percentComplete() == null ? 0 : this.percentComplete().hashCode());
        hashCode = 31 * hashCode + (this.errorDetails() == null ? 0 : this.errorDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecution)) {
            return false;
        }
        ActionExecution other = (ActionExecution)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.summary() == null ^ this.summary() == null) {
            return false;
        }
        if (other.summary() != null && !other.summary().equals(this.summary())) {
            return false;
        }
        if (other.lastStatusChange() == null ^ this.lastStatusChange() == null) {
            return false;
        }
        if (other.lastStatusChange() != null && !other.lastStatusChange().equals(this.lastStatusChange())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        if (other.token() != null && !other.token().equals(this.token())) {
            return false;
        }
        if (other.lastUpdatedBy() == null ^ this.lastUpdatedBy() == null) {
            return false;
        }
        if (other.lastUpdatedBy() != null && !other.lastUpdatedBy().equals(this.lastUpdatedBy())) {
            return false;
        }
        if (other.externalExecutionId() == null ^ this.externalExecutionId() == null) {
            return false;
        }
        if (other.externalExecutionId() != null && !other.externalExecutionId().equals(this.externalExecutionId())) {
            return false;
        }
        if (other.externalExecutionUrl() == null ^ this.externalExecutionUrl() == null) {
            return false;
        }
        if (other.externalExecutionUrl() != null && !other.externalExecutionUrl().equals(this.externalExecutionUrl())) {
            return false;
        }
        if (other.percentComplete() == null ^ this.percentComplete() == null) {
            return false;
        }
        if (other.percentComplete() != null && !other.percentComplete().equals(this.percentComplete())) {
            return false;
        }
        if (other.errorDetails() == null ^ this.errorDetails() == null) {
            return false;
        }
        return other.errorDetails() == null || other.errorDetails().equals(this.errorDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.summary() != null) {
            sb.append("Summary: ").append(this.summary()).append(",");
        }
        if (this.lastStatusChange() != null) {
            sb.append("LastStatusChange: ").append(this.lastStatusChange()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (this.lastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.lastUpdatedBy()).append(",");
        }
        if (this.externalExecutionId() != null) {
            sb.append("ExternalExecutionId: ").append(this.externalExecutionId()).append(",");
        }
        if (this.externalExecutionUrl() != null) {
            sb.append("ExternalExecutionUrl: ").append(this.externalExecutionUrl()).append(",");
        }
        if (this.percentComplete() != null) {
            sb.append("PercentComplete: ").append(this.percentComplete()).append(",");
        }
        if (this.errorDetails() != null) {
            sb.append("ErrorDetails: ").append(this.errorDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String status;
        private String summary;
        private Date lastStatusChange;
        private String token;
        private String lastUpdatedBy;
        private String externalExecutionId;
        private String externalExecutionUrl;
        private Integer percentComplete;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecution model) {
            this.setStatus(model.status);
            this.setSummary(model.summary);
            this.setLastStatusChange(model.lastStatusChange);
            this.setToken(model.token);
            this.setLastUpdatedBy(model.lastUpdatedBy);
            this.setExternalExecutionId(model.externalExecutionId);
            this.setExternalExecutionUrl(model.externalExecutionUrl);
            this.setPercentComplete(model.percentComplete);
            this.setErrorDetails(model.errorDetails);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ActionExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final Date getLastStatusChange() {
            return this.lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Date lastStatusChange) {
            this.lastStatusChange = StandardMemberCopier.copy((Date)lastStatusChange);
            return this;
        }

        public final void setLastStatusChange(Date lastStatusChange) {
            this.lastStatusChange = StandardMemberCopier.copy((Date)lastStatusChange);
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public final String getExternalExecutionUrl() {
            return this.externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        public final Integer getPercentComplete() {
            return this.percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        public final ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
        }

        public ActionExecution build() {
            return new ActionExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionExecution> {
        public Builder status(String var1);

        public Builder status(ActionExecutionStatus var1);

        public Builder summary(String var1);

        public Builder lastStatusChange(Date var1);

        public Builder token(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder externalExecutionId(String var1);

        public Builder externalExecutionUrl(String var1);

        public Builder percentComplete(Integer var1);

        public Builder errorDetails(ErrorDetails var1);
    }
}

