/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of metrics for an account as of a specified date.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsSummary implements SdkPojo, Serializable, ToCopyableBuilder<MetricsSummary.Builder, MetricsSummary> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("date")
            .getter(getter(MetricsSummary::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final SdkField<FindingMetricsValuePerSeverity> OPEN_FINDINGS_FIELD = SdkField
            .<FindingMetricsValuePerSeverity> builder(MarshallingType.SDK_POJO).memberName("openFindings")
            .getter(getter(MetricsSummary::openFindings)).setter(setter(Builder::openFindings))
            .constructor(FindingMetricsValuePerSeverity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openFindings").build()).build();

    private static final SdkField<List<CategoryWithFindingNum>> CATEGORIES_WITH_MOST_FINDINGS_FIELD = SdkField
            .<List<CategoryWithFindingNum>> builder(MarshallingType.LIST)
            .memberName("categoriesWithMostFindings")
            .getter(getter(MetricsSummary::categoriesWithMostFindings))
            .setter(setter(Builder::categoriesWithMostFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoriesWithMostFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoryWithFindingNum> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoryWithFindingNum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ScanNameWithFindingNum>> SCANS_WITH_MOST_OPEN_FINDINGS_FIELD = SdkField
            .<List<ScanNameWithFindingNum>> builder(MarshallingType.LIST)
            .memberName("scansWithMostOpenFindings")
            .getter(getter(MetricsSummary::scansWithMostOpenFindings))
            .setter(setter(Builder::scansWithMostOpenFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scansWithMostOpenFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanNameWithFindingNum> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanNameWithFindingNum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ScanNameWithFindingNum>> SCANS_WITH_MOST_OPEN_CRITICAL_FINDINGS_FIELD = SdkField
            .<List<ScanNameWithFindingNum>> builder(MarshallingType.LIST)
            .memberName("scansWithMostOpenCriticalFindings")
            .getter(getter(MetricsSummary::scansWithMostOpenCriticalFindings))
            .setter(setter(Builder::scansWithMostOpenCriticalFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scansWithMostOpenCriticalFindings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanNameWithFindingNum> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanNameWithFindingNum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD,
            OPEN_FINDINGS_FIELD, CATEGORIES_WITH_MOST_FINDINGS_FIELD, SCANS_WITH_MOST_OPEN_FINDINGS_FIELD,
            SCANS_WITH_MOST_OPEN_CRITICAL_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant date;

    private final FindingMetricsValuePerSeverity openFindings;

    private final List<CategoryWithFindingNum> categoriesWithMostFindings;

    private final List<ScanNameWithFindingNum> scansWithMostOpenFindings;

    private final List<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings;

    private MetricsSummary(BuilderImpl builder) {
        this.date = builder.date;
        this.openFindings = builder.openFindings;
        this.categoriesWithMostFindings = builder.categoriesWithMostFindings;
        this.scansWithMostOpenFindings = builder.scansWithMostOpenFindings;
        this.scansWithMostOpenCriticalFindings = builder.scansWithMostOpenCriticalFindings;
    }

    /**
     * <p>
     * The date from which the metrics summary information was retrieved.
     * </p>
     * 
     * @return The date from which the metrics summary information was retrieved.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The number of open findings of each severity.
     * </p>
     * 
     * @return The number of open findings of each severity.
     */
    public final FindingMetricsValuePerSeverity openFindings() {
        return openFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoriesWithMostFindings property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCategoriesWithMostFindings() {
        return categoriesWithMostFindings != null && !(categoriesWithMostFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoriesWithMostFindings} method.
     * </p>
     * 
     * @return A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most
     *         findings.
     */
    public final List<CategoryWithFindingNum> categoriesWithMostFindings() {
        return categoriesWithMostFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScansWithMostOpenFindings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasScansWithMostOpenFindings() {
        return scansWithMostOpenFindings != null && !(scansWithMostOpenFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScansWithMostOpenFindings} method.
     * </p>
     * 
     * @return A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
     *         findings.
     */
    public final List<ScanNameWithFindingNum> scansWithMostOpenFindings() {
        return scansWithMostOpenFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScansWithMostOpenCriticalFindings
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasScansWithMostOpenCriticalFindings() {
        return scansWithMostOpenCriticalFindings != null && !(scansWithMostOpenCriticalFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open critical
     * findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScansWithMostOpenCriticalFindings}
     * method.
     * </p>
     * 
     * @return A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
     *         critical findings.
     */
    public final List<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings() {
        return scansWithMostOpenCriticalFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(openFindings());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoriesWithMostFindings() ? categoriesWithMostFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScansWithMostOpenFindings() ? scansWithMostOpenFindings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasScansWithMostOpenCriticalFindings() ? scansWithMostOpenCriticalFindings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsSummary)) {
            return false;
        }
        MetricsSummary other = (MetricsSummary) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(openFindings(), other.openFindings())
                && hasCategoriesWithMostFindings() == other.hasCategoriesWithMostFindings()
                && Objects.equals(categoriesWithMostFindings(), other.categoriesWithMostFindings())
                && hasScansWithMostOpenFindings() == other.hasScansWithMostOpenFindings()
                && Objects.equals(scansWithMostOpenFindings(), other.scansWithMostOpenFindings())
                && hasScansWithMostOpenCriticalFindings() == other.hasScansWithMostOpenCriticalFindings()
                && Objects.equals(scansWithMostOpenCriticalFindings(), other.scansWithMostOpenCriticalFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MetricsSummary")
                .add("Date", date())
                .add("OpenFindings", openFindings())
                .add("CategoriesWithMostFindings", hasCategoriesWithMostFindings() ? categoriesWithMostFindings() : null)
                .add("ScansWithMostOpenFindings", hasScansWithMostOpenFindings() ? scansWithMostOpenFindings() : null)
                .add("ScansWithMostOpenCriticalFindings",
                        hasScansWithMostOpenCriticalFindings() ? scansWithMostOpenCriticalFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        case "openFindings":
            return Optional.ofNullable(clazz.cast(openFindings()));
        case "categoriesWithMostFindings":
            return Optional.ofNullable(clazz.cast(categoriesWithMostFindings()));
        case "scansWithMostOpenFindings":
            return Optional.ofNullable(clazz.cast(scansWithMostOpenFindings()));
        case "scansWithMostOpenCriticalFindings":
            return Optional.ofNullable(clazz.cast(scansWithMostOpenCriticalFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("date", DATE_FIELD);
        map.put("openFindings", OPEN_FINDINGS_FIELD);
        map.put("categoriesWithMostFindings", CATEGORIES_WITH_MOST_FINDINGS_FIELD);
        map.put("scansWithMostOpenFindings", SCANS_WITH_MOST_OPEN_FINDINGS_FIELD);
        map.put("scansWithMostOpenCriticalFindings", SCANS_WITH_MOST_OPEN_CRITICAL_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricsSummary, T> g) {
        return obj -> g.apply((MetricsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsSummary> {
        /**
         * <p>
         * The date from which the metrics summary information was retrieved.
         * </p>
         * 
         * @param date
         *        The date from which the metrics summary information was retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The number of open findings of each severity.
         * </p>
         * 
         * @param openFindings
         *        The number of open findings of each severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openFindings(FindingMetricsValuePerSeverity openFindings);

        /**
         * <p>
         * The number of open findings of each severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingMetricsValuePerSeverity.Builder}
         * avoiding the need to create one manually via {@link FindingMetricsValuePerSeverity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingMetricsValuePerSeverity.Builder#build()} is called
         * immediately and its result is passed to {@link #openFindings(FindingMetricsValuePerSeverity)}.
         * 
         * @param openFindings
         *        a consumer that will call methods on {@link FindingMetricsValuePerSeverity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openFindings(FindingMetricsValuePerSeverity)
         */
        default Builder openFindings(Consumer<FindingMetricsValuePerSeverity.Builder> openFindings) {
            return openFindings(FindingMetricsValuePerSeverity.builder().applyMutation(openFindings).build());
        }

        /**
         * <p>
         * A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most
         * findings.
         * </p>
         * 
         * @param categoriesWithMostFindings
         *        A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoriesWithMostFindings(Collection<CategoryWithFindingNum> categoriesWithMostFindings);

        /**
         * <p>
         * A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most
         * findings.
         * </p>
         * 
         * @param categoriesWithMostFindings
         *        A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoriesWithMostFindings(CategoryWithFindingNum... categoriesWithMostFindings);

        /**
         * <p>
         * A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most
         * findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #categoriesWithMostFindings(List<CategoryWithFindingNum>)}.
         * 
         * @param categoriesWithMostFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoriesWithMostFindings(java.util.Collection<CategoryWithFindingNum>)
         */
        Builder categoriesWithMostFindings(Consumer<CategoryWithFindingNum.Builder>... categoriesWithMostFindings);

        /**
         * <p>
         * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         * findings.
         * </p>
         * 
         * @param scansWithMostOpenFindings
         *        A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scansWithMostOpenFindings(Collection<ScanNameWithFindingNum> scansWithMostOpenFindings);

        /**
         * <p>
         * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         * findings.
         * </p>
         * 
         * @param scansWithMostOpenFindings
         *        A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scansWithMostOpenFindings(ScanNameWithFindingNum... scansWithMostOpenFindings);

        /**
         * <p>
         * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         * findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #scansWithMostOpenFindings(List<ScanNameWithFindingNum>)}.
         * 
         * @param scansWithMostOpenFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scansWithMostOpenFindings(java.util.Collection<ScanNameWithFindingNum>)
         */
        Builder scansWithMostOpenFindings(Consumer<ScanNameWithFindingNum.Builder>... scansWithMostOpenFindings);

        /**
         * <p>
         * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         * critical findings.
         * </p>
         * 
         * @param scansWithMostOpenCriticalFindings
         *        A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         *        critical findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scansWithMostOpenCriticalFindings(Collection<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings);

        /**
         * <p>
         * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         * critical findings.
         * </p>
         * 
         * @param scansWithMostOpenCriticalFindings
         *        A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         *        critical findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scansWithMostOpenCriticalFindings(ScanNameWithFindingNum... scansWithMostOpenCriticalFindings);

        /**
         * <p>
         * A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open
         * critical findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #scansWithMostOpenCriticalFindings(List<ScanNameWithFindingNum>)}.
         * 
         * @param scansWithMostOpenCriticalFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scansWithMostOpenCriticalFindings(java.util.Collection<ScanNameWithFindingNum>)
         */
        Builder scansWithMostOpenCriticalFindings(Consumer<ScanNameWithFindingNum.Builder>... scansWithMostOpenCriticalFindings);
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private FindingMetricsValuePerSeverity openFindings;

        private List<CategoryWithFindingNum> categoriesWithMostFindings = DefaultSdkAutoConstructList.getInstance();

        private List<ScanNameWithFindingNum> scansWithMostOpenFindings = DefaultSdkAutoConstructList.getInstance();

        private List<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsSummary model) {
            date(model.date);
            openFindings(model.openFindings);
            categoriesWithMostFindings(model.categoriesWithMostFindings);
            scansWithMostOpenFindings(model.scansWithMostOpenFindings);
            scansWithMostOpenCriticalFindings(model.scansWithMostOpenCriticalFindings);
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getOpenFindings() {
            return openFindings != null ? openFindings.toBuilder() : null;
        }

        public final void setOpenFindings(FindingMetricsValuePerSeverity.BuilderImpl openFindings) {
            this.openFindings = openFindings != null ? openFindings.build() : null;
        }

        @Override
        public final Builder openFindings(FindingMetricsValuePerSeverity openFindings) {
            this.openFindings = openFindings;
            return this;
        }

        public final List<CategoryWithFindingNum.Builder> getCategoriesWithMostFindings() {
            List<CategoryWithFindingNum.Builder> result = CategoriesWithMostFindingsCopier
                    .copyToBuilder(this.categoriesWithMostFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoriesWithMostFindings(Collection<CategoryWithFindingNum.BuilderImpl> categoriesWithMostFindings) {
            this.categoriesWithMostFindings = CategoriesWithMostFindingsCopier.copyFromBuilder(categoriesWithMostFindings);
        }

        @Override
        public final Builder categoriesWithMostFindings(Collection<CategoryWithFindingNum> categoriesWithMostFindings) {
            this.categoriesWithMostFindings = CategoriesWithMostFindingsCopier.copy(categoriesWithMostFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithMostFindings(CategoryWithFindingNum... categoriesWithMostFindings) {
            categoriesWithMostFindings(Arrays.asList(categoriesWithMostFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithMostFindings(Consumer<CategoryWithFindingNum.Builder>... categoriesWithMostFindings) {
            categoriesWithMostFindings(Stream.of(categoriesWithMostFindings)
                    .map(c -> CategoryWithFindingNum.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ScanNameWithFindingNum.Builder> getScansWithMostOpenFindings() {
            List<ScanNameWithFindingNum.Builder> result = ScansWithMostOpenFindingsCopier
                    .copyToBuilder(this.scansWithMostOpenFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScansWithMostOpenFindings(Collection<ScanNameWithFindingNum.BuilderImpl> scansWithMostOpenFindings) {
            this.scansWithMostOpenFindings = ScansWithMostOpenFindingsCopier.copyFromBuilder(scansWithMostOpenFindings);
        }

        @Override
        public final Builder scansWithMostOpenFindings(Collection<ScanNameWithFindingNum> scansWithMostOpenFindings) {
            this.scansWithMostOpenFindings = ScansWithMostOpenFindingsCopier.copy(scansWithMostOpenFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenFindings(ScanNameWithFindingNum... scansWithMostOpenFindings) {
            scansWithMostOpenFindings(Arrays.asList(scansWithMostOpenFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenFindings(Consumer<ScanNameWithFindingNum.Builder>... scansWithMostOpenFindings) {
            scansWithMostOpenFindings(Stream.of(scansWithMostOpenFindings)
                    .map(c -> ScanNameWithFindingNum.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ScanNameWithFindingNum.Builder> getScansWithMostOpenCriticalFindings() {
            List<ScanNameWithFindingNum.Builder> result = ScansWithMostOpenCriticalFindingsCopier
                    .copyToBuilder(this.scansWithMostOpenCriticalFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScansWithMostOpenCriticalFindings(
                Collection<ScanNameWithFindingNum.BuilderImpl> scansWithMostOpenCriticalFindings) {
            this.scansWithMostOpenCriticalFindings = ScansWithMostOpenCriticalFindingsCopier
                    .copyFromBuilder(scansWithMostOpenCriticalFindings);
        }

        @Override
        public final Builder scansWithMostOpenCriticalFindings(
                Collection<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings) {
            this.scansWithMostOpenCriticalFindings = ScansWithMostOpenCriticalFindingsCopier
                    .copy(scansWithMostOpenCriticalFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenCriticalFindings(ScanNameWithFindingNum... scansWithMostOpenCriticalFindings) {
            scansWithMostOpenCriticalFindings(Arrays.asList(scansWithMostOpenCriticalFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenCriticalFindings(
                Consumer<ScanNameWithFindingNum.Builder>... scansWithMostOpenCriticalFindings) {
            scansWithMostOpenCriticalFindings(Stream.of(scansWithMostOpenCriticalFindings)
                    .map(c -> ScanNameWithFindingNum.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricsSummary build() {
            return new MetricsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
