/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.CategoriesWithMostFindingsCopier;
import software.amazon.awssdk.services.codegurusecurity.model.CategoryWithFindingNum;
import software.amazon.awssdk.services.codegurusecurity.model.FindingMetricsValuePerSeverity;
import software.amazon.awssdk.services.codegurusecurity.model.ScanNameWithFindingNum;
import software.amazon.awssdk.services.codegurusecurity.model.ScansWithMostOpenCriticalFindingsCopier;
import software.amazon.awssdk.services.codegurusecurity.model.ScansWithMostOpenFindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricsSummary> {
    private static final SdkField<List<CategoryWithFindingNum>> CATEGORIES_WITH_MOST_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categoriesWithMostFindings").getter(MetricsSummary.getter(MetricsSummary::categoriesWithMostFindings)).setter(MetricsSummary.setter(Builder::categoriesWithMostFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoriesWithMostFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoryWithFindingNum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("date").getter(MetricsSummary.getter(MetricsSummary::date)).setter(MetricsSummary.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()}).build();
    private static final SdkField<FindingMetricsValuePerSeverity> OPEN_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openFindings").getter(MetricsSummary.getter(MetricsSummary::openFindings)).setter(MetricsSummary.setter(Builder::openFindings)).constructor(FindingMetricsValuePerSeverity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openFindings").build()}).build();
    private static final SdkField<List<ScanNameWithFindingNum>> SCANS_WITH_MOST_OPEN_CRITICAL_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scansWithMostOpenCriticalFindings").getter(MetricsSummary.getter(MetricsSummary::scansWithMostOpenCriticalFindings)).setter(MetricsSummary.setter(Builder::scansWithMostOpenCriticalFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scansWithMostOpenCriticalFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanNameWithFindingNum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ScanNameWithFindingNum>> SCANS_WITH_MOST_OPEN_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scansWithMostOpenFindings").getter(MetricsSummary.getter(MetricsSummary::scansWithMostOpenFindings)).setter(MetricsSummary.setter(Builder::scansWithMostOpenFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scansWithMostOpenFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanNameWithFindingNum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_WITH_MOST_FINDINGS_FIELD, DATE_FIELD, OPEN_FINDINGS_FIELD, SCANS_WITH_MOST_OPEN_CRITICAL_FINDINGS_FIELD, SCANS_WITH_MOST_OPEN_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("categoriesWithMostFindings", CATEGORIES_WITH_MOST_FINDINGS_FIELD);
            this.put("date", DATE_FIELD);
            this.put("openFindings", OPEN_FINDINGS_FIELD);
            this.put("scansWithMostOpenCriticalFindings", SCANS_WITH_MOST_OPEN_CRITICAL_FINDINGS_FIELD);
            this.put("scansWithMostOpenFindings", SCANS_WITH_MOST_OPEN_FINDINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<CategoryWithFindingNum> categoriesWithMostFindings;
    private final Instant date;
    private final FindingMetricsValuePerSeverity openFindings;
    private final List<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings;
    private final List<ScanNameWithFindingNum> scansWithMostOpenFindings;

    private MetricsSummary(BuilderImpl builder) {
        this.categoriesWithMostFindings = builder.categoriesWithMostFindings;
        this.date = builder.date;
        this.openFindings = builder.openFindings;
        this.scansWithMostOpenCriticalFindings = builder.scansWithMostOpenCriticalFindings;
        this.scansWithMostOpenFindings = builder.scansWithMostOpenFindings;
    }

    public final boolean hasCategoriesWithMostFindings() {
        return this.categoriesWithMostFindings != null && !(this.categoriesWithMostFindings instanceof SdkAutoConstructList);
    }

    public final List<CategoryWithFindingNum> categoriesWithMostFindings() {
        return this.categoriesWithMostFindings;
    }

    public final Instant date() {
        return this.date;
    }

    public final FindingMetricsValuePerSeverity openFindings() {
        return this.openFindings;
    }

    public final boolean hasScansWithMostOpenCriticalFindings() {
        return this.scansWithMostOpenCriticalFindings != null && !(this.scansWithMostOpenCriticalFindings instanceof SdkAutoConstructList);
    }

    public final List<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings() {
        return this.scansWithMostOpenCriticalFindings;
    }

    public final boolean hasScansWithMostOpenFindings() {
        return this.scansWithMostOpenFindings != null && !(this.scansWithMostOpenFindings instanceof SdkAutoConstructList);
    }

    public final List<ScanNameWithFindingNum> scansWithMostOpenFindings() {
        return this.scansWithMostOpenFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategoriesWithMostFindings() ? this.categoriesWithMostFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.openFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScansWithMostOpenCriticalFindings() ? this.scansWithMostOpenCriticalFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScansWithMostOpenFindings() ? this.scansWithMostOpenFindings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsSummary)) {
            return false;
        }
        MetricsSummary other = (MetricsSummary)obj;
        return this.hasCategoriesWithMostFindings() == other.hasCategoriesWithMostFindings() && Objects.equals(this.categoriesWithMostFindings(), other.categoriesWithMostFindings()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.openFindings(), other.openFindings()) && this.hasScansWithMostOpenCriticalFindings() == other.hasScansWithMostOpenCriticalFindings() && Objects.equals(this.scansWithMostOpenCriticalFindings(), other.scansWithMostOpenCriticalFindings()) && this.hasScansWithMostOpenFindings() == other.hasScansWithMostOpenFindings() && Objects.equals(this.scansWithMostOpenFindings(), other.scansWithMostOpenFindings());
    }

    public final String toString() {
        return ToString.builder((String)"MetricsSummary").add("CategoriesWithMostFindings", this.hasCategoriesWithMostFindings() ? this.categoriesWithMostFindings() : null).add("Date", (Object)this.date()).add("OpenFindings", (Object)this.openFindings()).add("ScansWithMostOpenCriticalFindings", this.hasScansWithMostOpenCriticalFindings() ? this.scansWithMostOpenCriticalFindings() : null).add("ScansWithMostOpenFindings", this.hasScansWithMostOpenFindings() ? this.scansWithMostOpenFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "categoriesWithMostFindings": {
                return Optional.ofNullable(clazz.cast(this.categoriesWithMostFindings()));
            }
            case "date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "openFindings": {
                return Optional.ofNullable(clazz.cast(this.openFindings()));
            }
            case "scansWithMostOpenCriticalFindings": {
                return Optional.ofNullable(clazz.cast(this.scansWithMostOpenCriticalFindings()));
            }
            case "scansWithMostOpenFindings": {
                return Optional.ofNullable(clazz.cast(this.scansWithMostOpenFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricsSummary, T> g) {
        return obj -> g.apply((MetricsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CategoryWithFindingNum> categoriesWithMostFindings = DefaultSdkAutoConstructList.getInstance();
        private Instant date;
        private FindingMetricsValuePerSeverity openFindings;
        private List<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings = DefaultSdkAutoConstructList.getInstance();
        private List<ScanNameWithFindingNum> scansWithMostOpenFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsSummary model) {
            this.categoriesWithMostFindings(model.categoriesWithMostFindings);
            this.date(model.date);
            this.openFindings(model.openFindings);
            this.scansWithMostOpenCriticalFindings(model.scansWithMostOpenCriticalFindings);
            this.scansWithMostOpenFindings(model.scansWithMostOpenFindings);
        }

        public final List<CategoryWithFindingNum.Builder> getCategoriesWithMostFindings() {
            List<CategoryWithFindingNum.Builder> result = CategoriesWithMostFindingsCopier.copyToBuilder(this.categoriesWithMostFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoriesWithMostFindings(Collection<CategoryWithFindingNum.BuilderImpl> categoriesWithMostFindings) {
            this.categoriesWithMostFindings = CategoriesWithMostFindingsCopier.copyFromBuilder(categoriesWithMostFindings);
        }

        @Override
        public final Builder categoriesWithMostFindings(Collection<CategoryWithFindingNum> categoriesWithMostFindings) {
            this.categoriesWithMostFindings = CategoriesWithMostFindingsCopier.copy(categoriesWithMostFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithMostFindings(CategoryWithFindingNum ... categoriesWithMostFindings) {
            this.categoriesWithMostFindings(Arrays.asList(categoriesWithMostFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithMostFindings(Consumer<CategoryWithFindingNum.Builder> ... categoriesWithMostFindings) {
            this.categoriesWithMostFindings(Stream.of(categoriesWithMostFindings).map(c -> (CategoryWithFindingNum)((CategoryWithFindingNum.Builder)CategoryWithFindingNum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getOpenFindings() {
            return this.openFindings != null ? this.openFindings.toBuilder() : null;
        }

        public final void setOpenFindings(FindingMetricsValuePerSeverity.BuilderImpl openFindings) {
            this.openFindings = openFindings != null ? openFindings.build() : null;
        }

        @Override
        public final Builder openFindings(FindingMetricsValuePerSeverity openFindings) {
            this.openFindings = openFindings;
            return this;
        }

        public final List<ScanNameWithFindingNum.Builder> getScansWithMostOpenCriticalFindings() {
            List<ScanNameWithFindingNum.Builder> result = ScansWithMostOpenCriticalFindingsCopier.copyToBuilder(this.scansWithMostOpenCriticalFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScansWithMostOpenCriticalFindings(Collection<ScanNameWithFindingNum.BuilderImpl> scansWithMostOpenCriticalFindings) {
            this.scansWithMostOpenCriticalFindings = ScansWithMostOpenCriticalFindingsCopier.copyFromBuilder(scansWithMostOpenCriticalFindings);
        }

        @Override
        public final Builder scansWithMostOpenCriticalFindings(Collection<ScanNameWithFindingNum> scansWithMostOpenCriticalFindings) {
            this.scansWithMostOpenCriticalFindings = ScansWithMostOpenCriticalFindingsCopier.copy(scansWithMostOpenCriticalFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenCriticalFindings(ScanNameWithFindingNum ... scansWithMostOpenCriticalFindings) {
            this.scansWithMostOpenCriticalFindings(Arrays.asList(scansWithMostOpenCriticalFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenCriticalFindings(Consumer<ScanNameWithFindingNum.Builder> ... scansWithMostOpenCriticalFindings) {
            this.scansWithMostOpenCriticalFindings(Stream.of(scansWithMostOpenCriticalFindings).map(c -> (ScanNameWithFindingNum)((ScanNameWithFindingNum.Builder)ScanNameWithFindingNum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ScanNameWithFindingNum.Builder> getScansWithMostOpenFindings() {
            List<ScanNameWithFindingNum.Builder> result = ScansWithMostOpenFindingsCopier.copyToBuilder(this.scansWithMostOpenFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScansWithMostOpenFindings(Collection<ScanNameWithFindingNum.BuilderImpl> scansWithMostOpenFindings) {
            this.scansWithMostOpenFindings = ScansWithMostOpenFindingsCopier.copyFromBuilder(scansWithMostOpenFindings);
        }

        @Override
        public final Builder scansWithMostOpenFindings(Collection<ScanNameWithFindingNum> scansWithMostOpenFindings) {
            this.scansWithMostOpenFindings = ScansWithMostOpenFindingsCopier.copy(scansWithMostOpenFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenFindings(ScanNameWithFindingNum ... scansWithMostOpenFindings) {
            this.scansWithMostOpenFindings(Arrays.asList(scansWithMostOpenFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scansWithMostOpenFindings(Consumer<ScanNameWithFindingNum.Builder> ... scansWithMostOpenFindings) {
            this.scansWithMostOpenFindings(Stream.of(scansWithMostOpenFindings).map(c -> (ScanNameWithFindingNum)((ScanNameWithFindingNum.Builder)ScanNameWithFindingNum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricsSummary build() {
            return new MetricsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricsSummary> {
        public Builder categoriesWithMostFindings(Collection<CategoryWithFindingNum> var1);

        public Builder categoriesWithMostFindings(CategoryWithFindingNum ... var1);

        public Builder categoriesWithMostFindings(Consumer<CategoryWithFindingNum.Builder> ... var1);

        public Builder date(Instant var1);

        public Builder openFindings(FindingMetricsValuePerSeverity var1);

        default public Builder openFindings(Consumer<FindingMetricsValuePerSeverity.Builder> openFindings) {
            return this.openFindings((FindingMetricsValuePerSeverity)((FindingMetricsValuePerSeverity.Builder)FindingMetricsValuePerSeverity.builder().applyMutation(openFindings)).build());
        }

        public Builder scansWithMostOpenCriticalFindings(Collection<ScanNameWithFindingNum> var1);

        public Builder scansWithMostOpenCriticalFindings(ScanNameWithFindingNum ... var1);

        public Builder scansWithMostOpenCriticalFindings(Consumer<ScanNameWithFindingNum.Builder> ... var1);

        public Builder scansWithMostOpenFindings(Collection<ScanNameWithFindingNum> var1);

        public Builder scansWithMostOpenFindings(ScanNameWithFindingNum ... var1);

        public Builder scansWithMostOpenFindings(Consumer<ScanNameWithFindingNum.Builder> ... var1);
    }
}

