/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityAsyncClient;
import software.amazon.awssdk.services.codegurusecurity.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ScanSummary;

public class ListScansPublisher
implements SdkPublisher<ListScansResponse> {
    private final CodeGuruSecurityAsyncClient client;
    private final ListScansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScansPublisher(CodeGuruSecurityAsyncClient client, ListScansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScansPublisher(CodeGuruSecurityAsyncClient client, ListScansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScanSummary> summaries() {
        Function<ListScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScansResponseFetcher
    implements AsyncPageFetcher<ListScansResponse> {
        private ListScansResponseFetcher() {
        }

        public boolean hasNextPage(ListScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScansResponse> nextPage(ListScansResponse previousPage) {
            if (previousPage == null) {
                return ListScansPublisher.this.client.listScans(ListScansPublisher.this.firstRequest);
            }
            return ListScansPublisher.this.client.listScans((ListScansRequest)((Object)ListScansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

