/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurusecurity.model.ErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFindingsError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetFindingsError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(BatchGetFindingsError.getter(BatchGetFindingsError::errorCodeAsString)).setter(BatchGetFindingsError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingId").getter(BatchGetFindingsError.getter(BatchGetFindingsError::findingId)).setter(BatchGetFindingsError.setter(Builder::findingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(BatchGetFindingsError.getter(BatchGetFindingsError::message)).setter(BatchGetFindingsError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanName").getter(BatchGetFindingsError.getter(BatchGetFindingsError::scanName)).setter(BatchGetFindingsError.setter(Builder::scanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, FINDING_ID_FIELD, MESSAGE_FIELD, SCAN_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String findingId;
    private final String message;
    private final String scanName;

    private BatchGetFindingsError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.findingId = builder.findingId;
        this.message = builder.message;
        this.scanName = builder.scanName;
    }

    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String findingId() {
        return this.findingId;
    }

    public final String message() {
        return this.message;
    }

    public final String scanName() {
        return this.scanName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingsError)) {
            return false;
        }
        BatchGetFindingsError other = (BatchGetFindingsError)obj;
        return Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.findingId(), other.findingId()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.scanName(), other.scanName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFindingsError").add("ErrorCode", (Object)this.errorCodeAsString()).add("FindingId", (Object)this.findingId()).add("Message", (Object)this.message()).add("ScanName", (Object)this.scanName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "findingId": {
                return Optional.ofNullable(clazz.cast(this.findingId()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "scanName": {
                return Optional.ofNullable(clazz.cast(this.scanName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingsError, T> g) {
        return obj -> g.apply((BatchGetFindingsError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String findingId;
        private String message;
        private String scanName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingsError model) {
            this.errorCode(model.errorCode);
            this.findingId(model.findingId);
            this.message(model.message);
            this.scanName(model.scanName);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getFindingId() {
            return this.findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getScanName() {
            return this.scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public BatchGetFindingsError build() {
            return new BatchGetFindingsError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetFindingsError> {
        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder findingId(String var1);

        public Builder message(String var1);

        public Builder scanName(String var1);
    }
}

