/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.Recommendation;
import software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix;
import software.amazon.awssdk.services.codegurusecurity.model.SuggestedFixesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Remediation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Remediation> {
    private static final SdkField<Recommendation> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendation").getter(Remediation.getter(Remediation::recommendation)).setter(Remediation.setter(Builder::recommendation)).constructor(Recommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<List<SuggestedFix>> SUGGESTED_FIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suggestedFixes").getter(Remediation.getter(Remediation::suggestedFixes)).setter(Remediation.setter(Builder::suggestedFixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedFixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggestedFix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_FIELD, SUGGESTED_FIXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Recommendation recommendation;
    private final List<SuggestedFix> suggestedFixes;

    private Remediation(BuilderImpl builder) {
        this.recommendation = builder.recommendation;
        this.suggestedFixes = builder.suggestedFixes;
    }

    public final Recommendation recommendation() {
        return this.recommendation;
    }

    public final boolean hasSuggestedFixes() {
        return this.suggestedFixes != null && !(this.suggestedFixes instanceof SdkAutoConstructList);
    }

    public final List<SuggestedFix> suggestedFixes() {
        return this.suggestedFixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestedFixes() ? this.suggestedFixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Remediation)) {
            return false;
        }
        Remediation other = (Remediation)obj;
        return Objects.equals(this.recommendation(), other.recommendation()) && this.hasSuggestedFixes() == other.hasSuggestedFixes() && Objects.equals(this.suggestedFixes(), other.suggestedFixes());
    }

    public final String toString() {
        return ToString.builder((String)"Remediation").add("Recommendation", (Object)this.recommendation()).add("SuggestedFixes", this.hasSuggestedFixes() ? this.suggestedFixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "suggestedFixes": {
                return Optional.ofNullable(clazz.cast(this.suggestedFixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Remediation, T> g) {
        return obj -> g.apply((Remediation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Recommendation recommendation;
        private List<SuggestedFix> suggestedFixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Remediation model) {
            this.recommendation(model.recommendation);
            this.suggestedFixes(model.suggestedFixes);
        }

        public final Recommendation.Builder getRecommendation() {
            return this.recommendation != null ? this.recommendation.toBuilder() : null;
        }

        public final void setRecommendation(Recommendation.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(Recommendation recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final List<SuggestedFix.Builder> getSuggestedFixes() {
            List<SuggestedFix.Builder> result = SuggestedFixesCopier.copyToBuilder(this.suggestedFixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestedFixes(Collection<SuggestedFix.BuilderImpl> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copyFromBuilder(suggestedFixes);
        }

        @Override
        public final Builder suggestedFixes(Collection<SuggestedFix> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copy(suggestedFixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(SuggestedFix ... suggestedFixes) {
            this.suggestedFixes(Arrays.asList(suggestedFixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(Consumer<SuggestedFix.Builder> ... suggestedFixes) {
            this.suggestedFixes(Stream.of(suggestedFixes).map(c -> (SuggestedFix)((SuggestedFix.Builder)SuggestedFix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Remediation build() {
            return new Remediation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Remediation> {
        public Builder recommendation(Recommendation var1);

        default public Builder recommendation(Consumer<Recommendation.Builder> recommendation) {
            return this.recommendation((Recommendation)((Recommendation.Builder)Recommendation.builder().applyMutation(recommendation)).build());
        }

        public Builder suggestedFixes(Collection<SuggestedFix> var1);

        public Builder suggestedFixes(SuggestedFix ... var1);

        public Builder suggestedFixes(Consumer<SuggestedFix.Builder> ... var1);
    }
}

