/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityClient;
import software.amazon.awssdk.services.codegurusecurity.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse;

public class ListFindingsMetricsIterable
implements SdkIterable<ListFindingsMetricsResponse> {
    private final CodeGuruSecurityClient client;
    private final ListFindingsMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsMetricsIterable(CodeGuruSecurityClient client, ListFindingsMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFindingsMetricsResponseFetcher();
    }

    public Iterator<ListFindingsMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountFindingsMetric> findingsMetrics() {
        Function<ListFindingsMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingsMetrics() != null) {
                return response.findingsMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFindingsMetricsResponseFetcher
    implements SyncPageFetcher<ListFindingsMetricsResponse> {
        private ListFindingsMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingsMetricsResponse nextPage(ListFindingsMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsMetricsIterable.this.client.listFindingsMetrics(ListFindingsMetricsIterable.this.firstRequest);
            }
            return ListFindingsMetricsIterable.this.client.listFindingsMetrics((ListFindingsMetricsRequest)((Object)ListFindingsMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

