/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClientBuilder;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerServiceClientConfiguration;
import software.amazon.awssdk.services.codegurureviewer.DefaultCodeGuruReviewerBaseClientBuilder;
import software.amazon.awssdk.services.codegurureviewer.DefaultCodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.endpoints.CodeGuruReviewerEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruReviewerClientBuilder
extends DefaultCodeGuruReviewerBaseClientBuilder<CodeGuruReviewerClientBuilder, CodeGuruReviewerClient>
implements CodeGuruReviewerClientBuilder {
    DefaultCodeGuruReviewerClientBuilder() {
    }

    @Override
    public DefaultCodeGuruReviewerClientBuilder endpointProvider(CodeGuruReviewerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruReviewerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeGuruReviewerClientBuilder.validateClientOptions(clientConfiguration);
        CodeGuruReviewerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeGuruReviewerClient client = new DefaultCodeGuruReviewerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeGuruReviewerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeGuruReviewerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

