/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.CodeReviewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCodeReviewRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, CreateCodeReviewRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateCodeReviewRequest.getter(CreateCodeReviewRequest::name)).setter(CreateCodeReviewRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> REPOSITORY_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryAssociationArn").getter(CreateCodeReviewRequest.getter(CreateCodeReviewRequest::repositoryAssociationArn)).setter(CreateCodeReviewRequest.setter(Builder::repositoryAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAssociationArn").build()}).build();
    private static final SdkField<CodeReviewType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Type").getter(CreateCodeReviewRequest.getter(CreateCodeReviewRequest::type)).setter(CreateCodeReviewRequest.setter(Builder::type)).constructor(CodeReviewType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateCodeReviewRequest.getter(CreateCodeReviewRequest::clientRequestToken)).setter(CreateCodeReviewRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REPOSITORY_ASSOCIATION_ARN_FIELD, TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String name;
    private final String repositoryAssociationArn;
    private final CodeReviewType type;
    private final String clientRequestToken;

    private CreateCodeReviewRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.repositoryAssociationArn = builder.repositoryAssociationArn;
        this.type = builder.type;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String name() {
        return this.name;
    }

    public final String repositoryAssociationArn() {
        return this.repositoryAssociationArn;
    }

    public final CodeReviewType type() {
        return this.type;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeReviewRequest)) {
            return false;
        }
        CreateCodeReviewRequest other = (CreateCodeReviewRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.repositoryAssociationArn(), other.repositoryAssociationArn()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCodeReviewRequest").add("Name", (Object)this.name()).add("RepositoryAssociationArn", (Object)this.repositoryAssociationArn()).add("Type", (Object)this.type()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RepositoryAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.repositoryAssociationArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeReviewRequest, T> g) {
        return obj -> g.apply((CreateCodeReviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String repositoryAssociationArn;
        private CodeReviewType type;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeReviewRequest model) {
            super(model);
            this.name(model.name);
            this.repositoryAssociationArn(model.repositoryAssociationArn);
            this.type(model.type);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRepositoryAssociationArn() {
            return this.repositoryAssociationArn;
        }

        public final void setRepositoryAssociationArn(String repositoryAssociationArn) {
            this.repositoryAssociationArn = repositoryAssociationArn;
        }

        @Override
        @Transient
        public final Builder repositoryAssociationArn(String repositoryAssociationArn) {
            this.repositoryAssociationArn = repositoryAssociationArn;
            return this;
        }

        public final CodeReviewType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(CodeReviewType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        @Transient
        public final Builder type(CodeReviewType type) {
            this.type = type;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeReviewRequest build() {
            return new CreateCodeReviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCodeReviewRequest> {
        public Builder name(String var1);

        public Builder repositoryAssociationArn(String var1);

        public Builder type(CodeReviewType var1);

        default public Builder type(Consumer<CodeReviewType.Builder> type) {
            return this.type((CodeReviewType)((CodeReviewType.Builder)CodeReviewType.builder().applyMutation(type)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

