/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.NamesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.OwnersCopier;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderTypesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoryAssociationsRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, ListRepositoryAssociationsRequest> {
    private static final SdkField<List<String>> PROVIDER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::providerTypesAsStrings)).setter(ListRepositoryAssociationsRequest.setter(Builder::providerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::statesAsStrings)).setter(ListRepositoryAssociationsRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::names)).setter(ListRepositoryAssociationsRequest.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Name").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::owners)).setter(ListRepositoryAssociationsRequest.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Owner").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::maxResults)).setter(ListRepositoryAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRepositoryAssociationsRequest.getter(ListRepositoryAssociationsRequest::nextToken)).setter(ListRepositoryAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPES_FIELD, STATES_FIELD, NAMES_FIELD, OWNERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> providerTypes;
    private final List<String> states;
    private final List<String> names;
    private final List<String> owners;
    private final Integer maxResults;
    private final String nextToken;

    private ListRepositoryAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypes = builder.providerTypes;
        this.states = builder.states;
        this.names = builder.names;
        this.owners = builder.owners;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ProviderType> providerTypes() {
        return ProviderTypesCopier.copyStringToEnum(this.providerTypes);
    }

    public boolean hasProviderTypes() {
        return this.providerTypes != null && !(this.providerTypes instanceof SdkAutoConstructList);
    }

    public List<String> providerTypesAsStrings() {
        return this.providerTypes;
    }

    public List<RepositoryAssociationState> states() {
        return RepositoryAssociationStatesCopier.copyStringToEnum(this.states);
    }

    public boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public List<String> statesAsStrings() {
        return this.states;
    }

    public boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public List<String> names() {
        return this.names;
    }

    public boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public List<String> owners() {
        return this.owners;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.names());
        hashCode = 31 * hashCode + Objects.hashCode(this.owners());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryAssociationsRequest)) {
            return false;
        }
        ListRepositoryAssociationsRequest other = (ListRepositoryAssociationsRequest)((Object)obj);
        return Objects.equals(this.providerTypesAsStrings(), other.providerTypesAsStrings()) && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.names(), other.names()) && Objects.equals(this.owners(), other.owners()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRepositoryAssociationsRequest").add("ProviderTypes", this.providerTypesAsStrings()).add("States", this.statesAsStrings()).add("Names", this.names()).add("Owners", this.owners()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderTypes": {
                return Optional.ofNullable(clazz.cast(this.providerTypesAsStrings()));
            }
            case "States": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoryAssociationsRequest, T> g) {
        return obj -> g.apply((ListRepositoryAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private List<String> providerTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private List<String> owners = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoryAssociationsRequest model) {
            super(model);
            this.providerTypesWithStrings(model.providerTypes);
            this.statesWithStrings(model.states);
            this.names(model.names);
            this.owners(model.owners);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProviderTypes() {
            return this.providerTypes;
        }

        @Override
        public final Builder providerTypesWithStrings(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypesWithStrings(String ... providerTypes) {
            this.providerTypesWithStrings(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        public final Builder providerTypes(Collection<ProviderType> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copyEnumToString(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(ProviderType ... providerTypes) {
            this.providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        public final void setProviderTypes(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
        }

        public final Collection<String> getStates() {
            return this.states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = RepositoryAssociationStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<RepositoryAssociationState> states) {
            this.states = RepositoryAssociationStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(RepositoryAssociationState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = RepositoryAssociationStatesCopier.copy(states);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = NamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = NamesCopier.copy(names);
        }

        public final Collection<String> getOwners() {
            return this.owners;
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnersCopier.copy(owners);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoryAssociationsRequest build() {
            return new ListRepositoryAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoryAssociationsRequest> {
        public Builder providerTypesWithStrings(Collection<String> var1);

        public Builder providerTypesWithStrings(String ... var1);

        public Builder providerTypes(Collection<ProviderType> var1);

        public Builder providerTypes(ProviderType ... var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<RepositoryAssociationState> var1);

        public Builder states(RepositoryAssociationState ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

