/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeReviewsResponse extends CodeGuruReviewerResponse implements
        ToCopyableBuilder<ListCodeReviewsResponse.Builder, ListCodeReviewsResponse> {
    private static final SdkField<List<CodeReviewSummary>> CODE_REVIEW_SUMMARIES_FIELD = SdkField
            .<List<CodeReviewSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListCodeReviewsResponse::codeReviewSummaries))
            .setter(setter(Builder::codeReviewSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeReviewSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeReviewSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeReviewSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCodeReviewsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REVIEW_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CodeReviewSummary> codeReviewSummaries;

    private final String nextToken;

    private ListCodeReviewsResponse(BuilderImpl builder) {
        super(builder);
        this.codeReviewSummaries = builder.codeReviewSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CodeReviewSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCodeReviewSummaries() {
        return codeReviewSummaries != null && !(codeReviewSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of code reviews that meet the criteria of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCodeReviewSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of code reviews that meet the criteria of the request.
     */
    public List<CodeReviewSummary> codeReviewSummaries() {
        return codeReviewSummaries;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeReviewSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeReviewsResponse)) {
            return false;
        }
        ListCodeReviewsResponse other = (ListCodeReviewsResponse) obj;
        return Objects.equals(codeReviewSummaries(), other.codeReviewSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCodeReviewsResponse").add("CodeReviewSummaries", codeReviewSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeReviewSummaries":
            return Optional.ofNullable(clazz.cast(codeReviewSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodeReviewsResponse, T> g) {
        return obj -> g.apply((ListCodeReviewsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCodeReviewsResponse> {
        /**
         * <p>
         * A list of code reviews that meet the criteria of the request.
         * </p>
         * 
         * @param codeReviewSummaries
         *        A list of code reviews that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewSummaries(Collection<CodeReviewSummary> codeReviewSummaries);

        /**
         * <p>
         * A list of code reviews that meet the criteria of the request.
         * </p>
         * 
         * @param codeReviewSummaries
         *        A list of code reviews that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeReviewSummaries(CodeReviewSummary... codeReviewSummaries);

        /**
         * <p>
         * A list of code reviews that meet the criteria of the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeReviewSummary>.Builder} avoiding the
         * need to create one manually via {@link List<CodeReviewSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeReviewSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #codeReviewSummaries(List<CodeReviewSummary>)}.
         * 
         * @param codeReviewSummaries
         *        a consumer that will call methods on {@link List<CodeReviewSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeReviewSummaries(List<CodeReviewSummary>)
         */
        Builder codeReviewSummaries(Consumer<CodeReviewSummary.Builder>... codeReviewSummaries);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeGuruReviewerResponse.BuilderImpl implements Builder {
        private List<CodeReviewSummary> codeReviewSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeReviewsResponse model) {
            super(model);
            codeReviewSummaries(model.codeReviewSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<CodeReviewSummary.Builder> getCodeReviewSummaries() {
            return codeReviewSummaries != null ? codeReviewSummaries.stream().map(CodeReviewSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder codeReviewSummaries(Collection<CodeReviewSummary> codeReviewSummaries) {
            this.codeReviewSummaries = CodeReviewSummariesCopier.copy(codeReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeReviewSummaries(CodeReviewSummary... codeReviewSummaries) {
            codeReviewSummaries(Arrays.asList(codeReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeReviewSummaries(Consumer<CodeReviewSummary.Builder>... codeReviewSummaries) {
            codeReviewSummaries(Stream.of(codeReviewSummaries).map(c -> CodeReviewSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCodeReviewSummaries(Collection<CodeReviewSummary.BuilderImpl> codeReviewSummaries) {
            this.codeReviewSummaries = CodeReviewSummariesCopier.copyFromBuilder(codeReviewSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCodeReviewsResponse build() {
            return new ListCodeReviewsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
