/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProviderType {
    CODE_COMMIT("CodeCommit"),
    GIT_HUB("GitHub"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ProviderType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProviderType> knownValues() {
        return Stream.of(ProviderType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

