/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, GetProfileRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(GetProfileRequest.getter(GetProfileRequest::accept)).setter(GetProfileRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetProfileRequest.getter(GetProfileRequest::endTime)).setter(GetProfileRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDepth").getter(GetProfileRequest.getter(GetProfileRequest::maxDepth)).setter(GetProfileRequest.setter(Builder::maxDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxDepth").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(GetProfileRequest.getter(GetProfileRequest::period)).setter(GetProfileRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(GetProfileRequest.getter(GetProfileRequest::profilingGroupName)).setter(GetProfileRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetProfileRequest.getter(GetProfileRequest::startTime)).setter(GetProfileRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, END_TIME_FIELD, MAX_DEPTH_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProfileRequest.memberNameToFieldInitializer();
    private final String accept;
    private final Instant endTime;
    private final Integer maxDepth;
    private final String period;
    private final String profilingGroupName;
    private final Instant startTime;

    private GetProfileRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.endTime = builder.endTime;
        this.maxDepth = builder.maxDepth;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    public final String accept() {
        return this.accept;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxDepth() {
        return this.maxDepth;
    }

    public final String period() {
        return this.period;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileRequest)) {
            return false;
        }
        GetProfileRequest other = (GetProfileRequest)((Object)obj);
        return Objects.equals(this.accept(), other.accept()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxDepth(), other.maxDepth()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileRequest").add("Accept", (Object)this.accept()).add("EndTime", (Object)this.endTime()).add("MaxDepth", (Object)this.maxDepth()).add("Period", (Object)this.period()).add("ProfilingGroupName", (Object)this.profilingGroupName()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "maxDepth": {
                return Optional.ofNullable(clazz.cast(this.maxDepth()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Accept", ACCEPT_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("maxDepth", MAX_DEPTH_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("profilingGroupName", PROFILING_GROUP_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProfileRequest, T> g) {
        return obj -> g.apply((GetProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private String accept;
        private Instant endTime;
        private Integer maxDepth;
        private String period;
        private String profilingGroupName;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileRequest model) {
            super(model);
            this.accept(model.accept);
            this.endTime(model.endTime);
            this.maxDepth(model.maxDepth);
            this.period(model.period);
            this.profilingGroupName(model.profilingGroupName);
            this.startTime(model.startTime);
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxDepth() {
            return this.maxDepth;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileRequest build() {
            return new GetProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileRequest> {
        public Builder accept(String var1);

        public Builder endTime(Instant var1);

        public Builder maxDepth(Integer var1);

        public Builder period(String var1);

        public Builder profilingGroupName(String var1);

        public Builder startTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

