/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.AggregationPeriod;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.OrderBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileTimesRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, ListProfileTimesRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::endTime)).setter(ListProfileTimesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::maxResults)).setter(ListProfileTimesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::nextToken)).setter(ListProfileTimesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orderBy").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::orderByAsString)).setter(ListProfileTimesRequest.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("orderBy").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::periodAsString)).setter(ListProfileTimesRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::profilingGroupName)).setter(ListProfileTimesRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListProfileTimesRequest.getter(ListProfileTimesRequest::startTime)).setter(ListProfileTimesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProfileTimesRequest.memberNameToFieldInitializer();
    private final Instant endTime;
    private final Integer maxResults;
    private final String nextToken;
    private final String orderBy;
    private final String period;
    private final String profilingGroupName;
    private final Instant startTime;

    private ListProfileTimesRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final OrderBy orderBy() {
        return OrderBy.fromValue(this.orderBy);
    }

    public final String orderByAsString() {
        return this.orderBy;
    }

    public final AggregationPeriod period() {
        return AggregationPeriod.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileTimesRequest)) {
            return false;
        }
        ListProfileTimesRequest other = (ListProfileTimesRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderByAsString(), other.orderByAsString()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileTimesRequest").add("EndTime", (Object)this.endTime()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OrderBy", (Object)this.orderByAsString()).add("Period", (Object)this.periodAsString()).add("ProfilingGroupName", (Object)this.profilingGroupName()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderByAsString()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endTime", END_TIME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("profilingGroupName", PROFILING_GROUP_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileTimesRequest, T> g) {
        return obj -> g.apply((ListProfileTimesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private Integer maxResults;
        private String nextToken;
        private String orderBy;
        private String period;
        private String profilingGroupName;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileTimesRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.orderBy(model.orderBy);
            this.period(model.period);
            this.profilingGroupName(model.profilingGroupName);
            this.startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(AggregationPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfileTimesRequest build() {
            return new ListProfileTimesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileTimesRequest> {
        public Builder endTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder orderBy(String var1);

        public Builder orderBy(OrderBy var1);

        public Builder period(String var1);

        public Builder period(AggregationPeriod var1);

        public Builder profilingGroupName(String var1);

        public Builder startTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

