/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the getProfileRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<GetProfileRequest.Builder, GetProfileRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(GetProfileRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(GetProfileRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDepth").getter(getter(GetProfileRequest::maxDepth)).setter(setter(Builder::maxDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxDepth").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(GetProfileRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(GetProfileRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(GetProfileRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, END_TIME_FIELD,
            MAX_DEPTH_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));

    private final String accept;

    private final Instant endTime;

    private final Integer maxDepth;

    private final String period;

    private final String profilingGroupName;

    private final Instant startTime;

    private GetProfileRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.endTime = builder.endTime;
        this.maxDepth = builder.maxDepth;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The format of the returned profiling data. The format maps to the <code>Accept</code> and
     * <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default .
     * </p>
     * 
     * <pre>
     * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
     * </pre>
     * 
     * @return The format of the returned profiling data. The format maps to the <code>Accept</code> and
     *         <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the
     *         default . </p>
     * 
     * <pre><code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * The end time of the requested profile. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * <p>
     * If you specify <code>endTime</code>, then you must also specify <code>period</code> or <code>startTime</code>,
     * but not both.
     * </p>
     * 
     * @return The end time of the requested profile. Specify using the ISO 8601 format. For example,
     *         2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
     *         <p>
     *         If you specify <code>endTime</code>, then you must also specify <code>period</code> or
     *         <code>startTime</code>, but not both.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum depth of the stacks in the code that is represented in the aggregated profile. For example, if
     * CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method
     * <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is set to 2,
     * then the aggregated profile contains representations of methods <code>A</code> and <code>B</code>.
     * </p>
     * 
     * @return The maximum depth of the stacks in the code that is represented in the aggregated profile. For example,
     *         if CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method
     *         <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is
     *         set to 2, then the aggregated profile contains representations of methods <code>A</code> and
     *         <code>B</code>.
     */
    public final Integer maxDepth() {
        return maxDepth;
    }

    /**
     * <p>
     * Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned aggregated
     * profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt; To get the latest aggregated profile, specify only &lt;code&gt;period&lt;/code&gt;. &lt;/p&gt; </code>
     * </pre>
     * 
     * @return Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned
     *         aggregated profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>. </p>
     * 
     * <pre><code> &lt;p&gt; To get the latest aggregated profile, specify only &lt;code&gt;period&lt;/code&gt;. &lt;/p&gt; </code>
     */
    public final String period() {
        return period;
    }

    /**
     * <p>
     * The name of the profiling group to get.
     * </p>
     * 
     * @return The name of the profiling group to get.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The start time of the profile to get. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
     * represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt; If you specify &lt;code&gt;startTime&lt;/code&gt;, then you must also specify &lt;code&gt;period&lt;/code&gt; or &lt;code&gt;endTime&lt;/code&gt;, but not both. &lt;/p&gt; </code>
     * </pre>
     * 
     * @return The start time of the profile to get. Specify using the ISO 8601 format. For example,
     *         2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
     * 
     * <pre><code> &lt;p&gt; If you specify &lt;code&gt;startTime&lt;/code&gt;, then you must also specify &lt;code&gt;period&lt;/code&gt; or &lt;code&gt;endTime&lt;/code&gt;, but not both. &lt;/p&gt; </code>
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileRequest)) {
            return false;
        }
        GetProfileRequest other = (GetProfileRequest) obj;
        return Objects.equals(accept(), other.accept()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxDepth(), other.maxDepth()) && Objects.equals(period(), other.period())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileRequest").add("Accept", accept()).add("EndTime", endTime())
                .add("MaxDepth", maxDepth()).add("Period", period()).add("ProfilingGroupName", profilingGroupName())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxDepth":
            return Optional.ofNullable(clazz.cast(maxDepth()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileRequest, T> g) {
        return obj -> g.apply((GetProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetProfileRequest> {
        /**
         * <p>
         * The format of the returned profiling data. The format maps to the <code>Accept</code> and
         * <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default .
         * </p>
         * 
         * <pre>
         * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
         * </pre>
         * 
         * @param accept
         *        The format of the returned profiling data. The format maps to the <code>Accept</code> and
         *        <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the
         *        default . </p>
         * 
         *        <pre>
         * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * The end time of the requested profile. Specify using the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * <p>
         * If you specify <code>endTime</code>, then you must also specify <code>period</code> or <code>startTime</code>
         * , but not both.
         * </p>
         * 
         * @param endTime
         *        The end time of the requested profile. Specify using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>
         *        <p>
         *        If you specify <code>endTime</code>, then you must also specify <code>period</code> or
         *        <code>startTime</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum depth of the stacks in the code that is represented in the aggregated profile. For example, if
         * CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method
         * <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is set
         * to 2, then the aggregated profile contains representations of methods <code>A</code> and <code>B</code>.
         * </p>
         * 
         * @param maxDepth
         *        The maximum depth of the stacks in the code that is represented in the aggregated profile. For
         *        example, if CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which
         *        calls method <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the
         *        <code>maxDepth</code> is set to 2, then the aggregated profile contains representations of methods
         *        <code>A</code> and <code>B</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDepth(Integer maxDepth);

        /**
         * <p>
         * Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned
         * aggregated profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>.
         * </p>
         * 
         * <pre>
         * <code> &lt;p&gt; To get the latest aggregated profile, specify only &lt;code&gt;period&lt;/code&gt;. &lt;/p&gt; </code>
         * </pre>
         * 
         * @param period
         *        Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned
         *        aggregated profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>. </p>
         * 
         *        <pre>
         * <code> &lt;p&gt; To get the latest aggregated profile, specify only &lt;code&gt;period&lt;/code&gt;. &lt;/p&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(String period);

        /**
         * <p>
         * The name of the profiling group to get.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The start time of the profile to get. Specify using the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * <pre>
         * <code> &lt;p&gt; If you specify &lt;code&gt;startTime&lt;/code&gt;, then you must also specify &lt;code&gt;period&lt;/code&gt; or &lt;code&gt;endTime&lt;/code&gt;, but not both. &lt;/p&gt; </code>
         * </pre>
         * 
         * @param startTime
         *        The start time of the profile to get. Specify using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>
         * 
         *        <pre>
         * <code> &lt;p&gt; If you specify &lt;code&gt;startTime&lt;/code&gt;, then you must also specify &lt;code&gt;period&lt;/code&gt; or &lt;code&gt;endTime&lt;/code&gt;, but not both. &lt;/p&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private String accept;

        private Instant endTime;

        private Integer maxDepth;

        private String period;

        private String profilingGroupName;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileRequest model) {
            super(model);
            accept(model.accept);
            endTime(model.endTime);
            maxDepth(model.maxDepth);
            period(model.period);
            profilingGroupName(model.profilingGroupName);
            startTime(model.startTime);
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxDepth() {
            return maxDepth;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileRequest build() {
            return new GetProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
