/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether profiling is enabled or disabled for a profiling group. It is used by <a
 * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code>
 * </a> to enable or disable profiling for a profiling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentOrchestrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentOrchestrationConfig.Builder, AgentOrchestrationConfig> {
    private static final SdkField<Boolean> PROFILING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("profilingEnabled").getter(getter(AgentOrchestrationConfig::profilingEnabled))
            .setter(setter(Builder::profilingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILING_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean profilingEnabled;

    private AgentOrchestrationConfig(BuilderImpl builder) {
        this.profilingEnabled = builder.profilingEnabled;
    }

    /**
     * <p>
     * A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to
     * <code>true</code> to enable profiling.
     * </p>
     * 
     * @return A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to
     *         <code>true</code> to enable profiling.
     */
    public final Boolean profilingEnabled() {
        return profilingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profilingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentOrchestrationConfig)) {
            return false;
        }
        AgentOrchestrationConfig other = (AgentOrchestrationConfig) obj;
        return Objects.equals(profilingEnabled(), other.profilingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentOrchestrationConfig").add("ProfilingEnabled", profilingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profilingEnabled":
            return Optional.ofNullable(clazz.cast(profilingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentOrchestrationConfig, T> g) {
        return obj -> g.apply((AgentOrchestrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentOrchestrationConfig> {
        /**
         * <p>
         * A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to
         * <code>true</code> to enable profiling.
         * </p>
         * 
         * @param profilingEnabled
         *        A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set
         *        to <code>true</code> to enable profiling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingEnabled(Boolean profilingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean profilingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentOrchestrationConfig model) {
            profilingEnabled(model.profilingEnabled);
        }

        public final Boolean getProfilingEnabled() {
            return profilingEnabled;
        }

        public final void setProfilingEnabled(Boolean profilingEnabled) {
            this.profilingEnabled = profilingEnabled;
        }

        @Override
        public final Builder profilingEnabled(Boolean profilingEnabled) {
            this.profilingEnabled = profilingEnabled;
            return this;
        }

        @Override
        public AgentOrchestrationConfig build() {
            return new AgentOrchestrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
