/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a profiling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfilingGroupDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfilingGroupDescription.Builder, ProfilingGroupDescription> {
    private static final SdkField<AgentOrchestrationConfig> AGENT_ORCHESTRATION_CONFIG_FIELD = SdkField
            .<AgentOrchestrationConfig> builder(MarshallingType.SDK_POJO).memberName("agentOrchestrationConfig")
            .getter(getter(ProfilingGroupDescription::agentOrchestrationConfig))
            .setter(setter(Builder::agentOrchestrationConfig)).constructor(AgentOrchestrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentOrchestrationConfig").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ProfilingGroupDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computePlatform").getter(getter(ProfilingGroupDescription::computePlatformAsString))
            .setter(setter(Builder::computePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ProfilingGroupDescription::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ProfilingGroupDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ProfilingStatus> PROFILING_STATUS_FIELD = SdkField
            .<ProfilingStatus> builder(MarshallingType.SDK_POJO).memberName("profilingStatus")
            .getter(getter(ProfilingGroupDescription::profilingStatus)).setter(setter(Builder::profilingStatus))
            .constructor(ProfilingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingStatus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ProfilingGroupDescription::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(ProfilingGroupDescription::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGENT_ORCHESTRATION_CONFIG_FIELD, ARN_FIELD, COMPUTE_PLATFORM_FIELD, CREATED_AT_FIELD, NAME_FIELD,
            PROFILING_STATUS_FIELD, TAGS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AgentOrchestrationConfig agentOrchestrationConfig;

    private final String arn;

    private final String computePlatform;

    private final Instant createdAt;

    private final String name;

    private final ProfilingStatus profilingStatus;

    private final Map<String, String> tags;

    private final Instant updatedAt;

    private ProfilingGroupDescription(BuilderImpl builder) {
        this.agentOrchestrationConfig = builder.agentOrchestrationConfig;
        this.arn = builder.arn;
        this.computePlatform = builder.computePlatform;
        this.createdAt = builder.createdAt;
        this.name = builder.name;
        this.profilingStatus = builder.profilingStatus;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
     * <code>AgentOrchestrationConfig</code> </a> object that indicates if the profiling group is enabled for profiled
     * or not.
     * </p>
     * 
     * @return An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
     *         <code>AgentOrchestrationConfig</code> </a> object that indicates if the profiling group is enabled for
     *         profiled or not.
     */
    public final AgentOrchestrationConfig agentOrchestrationConfig() {
        return agentOrchestrationConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) identifying the profiling group resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) identifying the profiling group resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
     * application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs on a
     * compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different
     * platform. The default is <code>Default</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
     *         application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs
     *         on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a
     *         different platform. The default is <code>Default</code>.
     * @see ComputePlatform
     */
    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(computePlatform);
    }

    /**
     * <p>
     * The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
     * application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs on a
     * compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different
     * platform. The default is <code>Default</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computePlatform}
     * will return {@link ComputePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computePlatformAsString}.
     * </p>
     * 
     * @return The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
     *         application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs
     *         on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a
     *         different platform. The default is <code>Default</code>.
     * @see ComputePlatform
     */
    public final String computePlatformAsString() {
        return computePlatform;
    }

    /**
     * <p>
     * The time when the profiling group was created. Specify using the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The time when the profiling group was created. Specify using the ISO 8601 format. For example,
     *         2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the profiling group.
     * </p>
     * 
     * @return The name of the profiling group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
     * <code>ProfilingStatus</code> </a> object that includes information about the last time a profile agent pinged
     * back, the last time a profile was received, and the aggregation period and start time for the most recent
     * aggregated profile.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
     *         <code>ProfilingStatus</code> </a> object that includes information about the last time a profile agent
     *         pinged back, the last time a profile was received, and the aggregation period and start time for the most
     *         recent aggregated profile.
     */
    public final ProfilingStatus profilingStatus() {
        return profilingStatus;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the tags that belong to this profiling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the tags that belong to this profiling group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For
     *         example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentOrchestrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(profilingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilingGroupDescription)) {
            return false;
        }
        ProfilingGroupDescription other = (ProfilingGroupDescription) obj;
        return Objects.equals(agentOrchestrationConfig(), other.agentOrchestrationConfig()) && Objects.equals(arn(), other.arn())
                && Objects.equals(computePlatformAsString(), other.computePlatformAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(name(), other.name())
                && Objects.equals(profilingStatus(), other.profilingStatus()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfilingGroupDescription").add("AgentOrchestrationConfig", agentOrchestrationConfig())
                .add("Arn", arn()).add("ComputePlatform", computePlatformAsString()).add("CreatedAt", createdAt())
                .add("Name", name()).add("ProfilingStatus", profilingStatus()).add("Tags", hasTags() ? tags() : null)
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentOrchestrationConfig":
            return Optional.ofNullable(clazz.cast(agentOrchestrationConfig()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "computePlatform":
            return Optional.ofNullable(clazz.cast(computePlatformAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "profilingStatus":
            return Optional.ofNullable(clazz.cast(profilingStatus()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfilingGroupDescription, T> g) {
        return obj -> g.apply((ProfilingGroupDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfilingGroupDescription> {
        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
         * <code>AgentOrchestrationConfig</code> </a> object that indicates if the profiling group is enabled for
         * profiled or not.
         * </p>
         * 
         * @param agentOrchestrationConfig
         *        An <a
         *        href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
         *        <code>AgentOrchestrationConfig</code> </a> object that indicates if the profiling group is enabled for
         *        profiled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig);

        /**
         * <p>
         * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
         * <code>AgentOrchestrationConfig</code> </a> object that indicates if the profiling group is enabled for
         * profiled or not.
         * </p>
         * This is a convenience that creates an instance of the {@link AgentOrchestrationConfig.Builder} avoiding the
         * need to create one manually via {@link AgentOrchestrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgentOrchestrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #agentOrchestrationConfig(AgentOrchestrationConfig)}.
         * 
         * @param agentOrchestrationConfig
         *        a consumer that will call methods on {@link AgentOrchestrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentOrchestrationConfig(AgentOrchestrationConfig)
         */
        default Builder agentOrchestrationConfig(Consumer<AgentOrchestrationConfig.Builder> agentOrchestrationConfig) {
            return agentOrchestrationConfig(AgentOrchestrationConfig.builder().applyMutation(agentOrchestrationConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) identifying the profiling group resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) identifying the profiling group resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
         * application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs on a
         * compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different
         * platform. The default is <code>Default</code>.
         * </p>
         * 
         * @param computePlatform
         *        The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
         *        application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application
         *        runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server,
         *        or a different platform. The default is <code>Default</code>.
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(String computePlatform);

        /**
         * <p>
         * The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
         * application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs on a
         * compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different
         * platform. The default is <code>Default</code>.
         * </p>
         * 
         * @param computePlatform
         *        The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled
         *        application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application
         *        runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server,
         *        or a different platform. The default is <code>Default</code>.
         * @see ComputePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputePlatform
         */
        Builder computePlatform(ComputePlatform computePlatform);

        /**
         * <p>
         * The time when the profiling group was created. Specify using the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param createdAt
         *        The time when the profiling group was created. Specify using the ISO 8601 format. For example,
         *        2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the profiling group.
         * </p>
         * 
         * @param name
         *        The name of the profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
         * <code>ProfilingStatus</code> </a> object that includes information about the last time a profile agent pinged
         * back, the last time a profile was received, and the aggregation period and start time for the most recent
         * aggregated profile.
         * </p>
         * 
         * @param profilingStatus
         *        A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
         *        <code>ProfilingStatus</code> </a> object that includes information about the last time a profile agent
         *        pinged back, the last time a profile was received, and the aggregation period and start time for the
         *        most recent aggregated profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingStatus(ProfilingStatus profilingStatus);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
         * <code>ProfilingStatus</code> </a> object that includes information about the last time a profile agent pinged
         * back, the last time a profile was received, and the aggregation period and start time for the most recent
         * aggregated profile.
         * </p>
         * This is a convenience that creates an instance of the {@link ProfilingStatus.Builder} avoiding the need to
         * create one manually via {@link ProfilingStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProfilingStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #profilingStatus(ProfilingStatus)}.
         * 
         * @param profilingStatus
         *        a consumer that will call methods on {@link ProfilingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilingStatus(ProfilingStatus)
         */
        default Builder profilingStatus(Consumer<ProfilingStatus.Builder> profilingStatus) {
            return profilingStatus(ProfilingStatus.builder().applyMutation(profilingStatus).build());
        }

        /**
         * <p>
         * A list of the tags that belong to this profiling group.
         * </p>
         * 
         * @param tags
         *        A list of the tags that belong to this profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For
         *        example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private AgentOrchestrationConfig agentOrchestrationConfig;

        private String arn;

        private String computePlatform;

        private Instant createdAt;

        private String name;

        private ProfilingStatus profilingStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfilingGroupDescription model) {
            agentOrchestrationConfig(model.agentOrchestrationConfig);
            arn(model.arn);
            computePlatform(model.computePlatform);
            createdAt(model.createdAt);
            name(model.name);
            profilingStatus(model.profilingStatus);
            tags(model.tags);
            updatedAt(model.updatedAt);
        }

        public final AgentOrchestrationConfig.Builder getAgentOrchestrationConfig() {
            return agentOrchestrationConfig != null ? agentOrchestrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig;
            return this;
        }

        public final void setAgentOrchestrationConfig(AgentOrchestrationConfig.BuilderImpl agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig != null ? agentOrchestrationConfig.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getComputePlatform() {
            return computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ProfilingStatus.Builder getProfilingStatus() {
            return profilingStatus != null ? profilingStatus.toBuilder() : null;
        }

        @Override
        public final Builder profilingStatus(ProfilingStatus profilingStatus) {
            this.profilingStatus = profilingStatus;
            return this;
        }

        public final void setProfilingStatus(ProfilingStatus.BuilderImpl profilingStatus) {
            this.profilingStatus = profilingStatus != null ? profilingStatus.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public ProfilingGroupDescription build() {
            return new ProfilingGroupDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
