/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the configureAgentRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureAgentRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<ConfigureAgentRequest.Builder, ConfigureAgentRequest> {
    private static final SdkField<String> FLEET_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetInstanceId").getter(getter(ConfigureAgentRequest::fleetInstanceId))
            .setter(setter(Builder::fleetInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetInstanceId").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(ConfigureAgentRequest::metadataAsStrings))
            .setter(setter(Builder::metadataWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(ConfigureAgentRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_INSTANCE_ID_FIELD,
            METADATA_FIELD, PROFILING_GROUP_NAME_FIELD));

    private final String fleetInstanceId;

    private final Map<String, String> metadata;

    private final String profilingGroupName;

    private ConfigureAgentRequest(BuilderImpl builder) {
        super(builder);
        this.fleetInstanceId = builder.fleetInstanceId;
        this.metadata = builder.metadata;
        this.profilingGroupName = builder.profilingGroupName;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an
     * Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container's task ID.
     * </p>
     * 
     * @return A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance
     *         is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the
     *         container's task ID.
     */
    public final String fleetInstanceId() {
        return fleetInstanceId;
    }

    /**
     * <p>
     * Metadata captured about the compute platform the agent is running on. It includes information about sampling and
     * reporting. The valid fields are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AGENT_ID</code> - The ID for an agent instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda
     * function times out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations
     * of a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda
     * invocation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata captured about the compute platform the agent is running on. It includes information about
     *         sampling and reporting. The valid fields are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AGENT_ID</code> - The ID for an agent instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda
     *         function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a
     *         Lambda function times out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two
     *         invocations of a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous
     *         Lambda invocation.
     *         </p>
     *         </li>
     */
    public final Map<MetadataField, String> metadata() {
        return MetadataCopier.copyStringToEnum(metadata);
    }

    /**
     * Returns true if the Metadata property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata captured about the compute platform the agent is running on. It includes information about sampling and
     * reporting. The valid fields are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AGENT_ID</code> - The ID for an agent instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda
     * function times out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations
     * of a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda
     * invocation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata captured about the compute platform the agent is running on. It includes information about
     *         sampling and reporting. The valid fields are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AGENT_ID</code> - The ID for an agent instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda
     *         function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a
     *         Lambda function times out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two
     *         invocations of a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous
     *         Lambda invocation.
     *         </p>
     *         </li>
     */
    public final Map<String, String> metadataAsStrings() {
        return metadata;
    }

    /**
     * <p>
     * The name of the profiling group for which the configured agent is collecting profiling data.
     * </p>
     * 
     * @return The name of the profiling group for which the configured agent is collecting profiling data.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadataAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureAgentRequest)) {
            return false;
        }
        ConfigureAgentRequest other = (ConfigureAgentRequest) obj;
        return Objects.equals(fleetInstanceId(), other.fleetInstanceId()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadataAsStrings(), other.metadataAsStrings())
                && Objects.equals(profilingGroupName(), other.profilingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureAgentRequest").add("FleetInstanceId", fleetInstanceId())
                .add("Metadata", hasMetadata() ? metadataAsStrings() : null).add("ProfilingGroupName", profilingGroupName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleetInstanceId":
            return Optional.ofNullable(clazz.cast(fleetInstanceId()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadataAsStrings()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureAgentRequest, T> g) {
        return obj -> g.apply((ConfigureAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ConfigureAgentRequest> {
        /**
         * <p>
         * A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an
         * Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container's task ID.
         * </p>
         * 
         * @param fleetInstanceId
         *        A universally unique identifier (UUID) for a profiling instance. For example, if the profiling
         *        instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is
         *        the container's task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetInstanceId(String fleetInstanceId);

        /**
         * <p>
         * Metadata captured about the compute platform the agent is running on. It includes information about sampling
         * and reporting. The valid fields are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AGENT_ID</code> - The ID for an agent instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda
         * function times out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two
         * invocations of a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous
         * Lambda invocation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metadata
         *        Metadata captured about the compute platform the agent is running on. It includes information about
         *        sampling and reporting. The valid fields are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AGENT_ID</code> - The ID for an agent instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a
         *        Lambda function times out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two
         *        invocations of a Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the
         *        previous Lambda invocation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataWithStrings(Map<String, String> metadata);

        /**
         * <p>
         * Metadata captured about the compute platform the agent is running on. It includes information about sampling
         * and reporting. The valid fields are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AGENT_ID</code> - The ID for an agent instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda
         * function times out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two
         * invocations of a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous
         * Lambda invocation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metadata
         *        Metadata captured about the compute platform the agent is running on. It includes information about
         *        sampling and reporting. The valid fields are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AGENT_ID</code> - The ID for an agent instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a
         *        Lambda function times out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two
         *        invocations of a Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the
         *        previous Lambda invocation.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<MetadataField, String> metadata);

        /**
         * <p>
         * The name of the profiling group for which the configured agent is collecting profiling data.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group for which the configured agent is collecting profiling data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private String fleetInstanceId;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureAgentRequest model) {
            super(model);
            fleetInstanceId(model.fleetInstanceId);
            metadataWithStrings(model.metadata);
            profilingGroupName(model.profilingGroupName);
        }

        public final String getFleetInstanceId() {
            return fleetInstanceId;
        }

        @Override
        public final Builder fleetInstanceId(String fleetInstanceId) {
            this.fleetInstanceId = fleetInstanceId;
            return this;
        }

        public final void setFleetInstanceId(String fleetInstanceId) {
            this.fleetInstanceId = fleetInstanceId;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        @Override
        public final Builder metadataWithStrings(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        @Override
        public final Builder metadata(Map<MetadataField, String> metadata) {
            this.metadata = MetadataCopier.copyEnumToString(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureAgentRequest build() {
            return new ConfigureAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
