/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.StringsCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.TargetFramesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Pattern
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Pattern> {
    private static final SdkField<List<String>> COUNTERS_TO_AGGREGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("countersToAggregate").getter(Pattern.getter(Pattern::countersToAggregate)).setter(Pattern.setter(Builder::countersToAggregate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countersToAggregate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Pattern.getter(Pattern::description)).setter(Pattern.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Pattern.getter(Pattern::id)).setter(Pattern.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Pattern.getter(Pattern::name)).setter(Pattern.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESOLUTION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionSteps").getter(Pattern.getter(Pattern::resolutionSteps)).setter(Pattern.setter(Builder::resolutionSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionSteps").build()}).build();
    private static final SdkField<List<List<String>>> TARGET_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetFrames").getter(Pattern.getter(Pattern::targetFrames)).setter(Pattern.setter(Builder::targetFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFrames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Double> THRESHOLD_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("thresholdPercent").getter(Pattern.getter(Pattern::thresholdPercent)).setter(Pattern.setter(Builder::thresholdPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTERS_TO_AGGREGATE_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, RESOLUTION_STEPS_FIELD, TARGET_FRAMES_FIELD, THRESHOLD_PERCENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> countersToAggregate;
    private final String description;
    private final String id;
    private final String name;
    private final String resolutionSteps;
    private final List<List<String>> targetFrames;
    private final Double thresholdPercent;

    private Pattern(BuilderImpl builder) {
        this.countersToAggregate = builder.countersToAggregate;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.resolutionSteps = builder.resolutionSteps;
        this.targetFrames = builder.targetFrames;
        this.thresholdPercent = builder.thresholdPercent;
    }

    public boolean hasCountersToAggregate() {
        return this.countersToAggregate != null && !(this.countersToAggregate instanceof SdkAutoConstructList);
    }

    public List<String> countersToAggregate() {
        return this.countersToAggregate;
    }

    public String description() {
        return this.description;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String resolutionSteps() {
        return this.resolutionSteps;
    }

    public boolean hasTargetFrames() {
        return this.targetFrames != null && !(this.targetFrames instanceof SdkAutoConstructList);
    }

    public List<List<String>> targetFrames() {
        return this.targetFrames;
    }

    public Double thresholdPercent() {
        return this.thresholdPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountersToAggregate() ? this.countersToAggregate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetFrames() ? this.targetFrames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pattern)) {
            return false;
        }
        Pattern other = (Pattern)obj;
        return this.hasCountersToAggregate() == other.hasCountersToAggregate() && Objects.equals(this.countersToAggregate(), other.countersToAggregate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resolutionSteps(), other.resolutionSteps()) && this.hasTargetFrames() == other.hasTargetFrames() && Objects.equals(this.targetFrames(), other.targetFrames()) && Objects.equals(this.thresholdPercent(), other.thresholdPercent());
    }

    public String toString() {
        return ToString.builder((String)"Pattern").add("CountersToAggregate", this.hasCountersToAggregate() ? this.countersToAggregate() : null).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ResolutionSteps", (Object)this.resolutionSteps()).add("TargetFrames", this.hasTargetFrames() ? this.targetFrames() : null).add("ThresholdPercent", (Object)this.thresholdPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "countersToAggregate": {
                return Optional.ofNullable(clazz.cast(this.countersToAggregate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resolutionSteps": {
                return Optional.ofNullable(clazz.cast(this.resolutionSteps()));
            }
            case "targetFrames": {
                return Optional.ofNullable(clazz.cast(this.targetFrames()));
            }
            case "thresholdPercent": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pattern, T> g) {
        return obj -> g.apply((Pattern)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> countersToAggregate = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String id;
        private String name;
        private String resolutionSteps;
        private List<List<String>> targetFrames = DefaultSdkAutoConstructList.getInstance();
        private Double thresholdPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(Pattern model) {
            this.countersToAggregate(model.countersToAggregate);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.resolutionSteps(model.resolutionSteps);
            this.targetFrames(model.targetFrames);
            this.thresholdPercent(model.thresholdPercent);
        }

        public final Collection<String> getCountersToAggregate() {
            if (this.countersToAggregate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.countersToAggregate;
        }

        @Override
        public final Builder countersToAggregate(Collection<String> countersToAggregate) {
            this.countersToAggregate = StringsCopier.copy(countersToAggregate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countersToAggregate(String ... countersToAggregate) {
            this.countersToAggregate(Arrays.asList(countersToAggregate));
            return this;
        }

        public final void setCountersToAggregate(Collection<String> countersToAggregate) {
            this.countersToAggregate = StringsCopier.copy(countersToAggregate);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResolutionSteps() {
            return this.resolutionSteps;
        }

        @Override
        public final Builder resolutionSteps(String resolutionSteps) {
            this.resolutionSteps = resolutionSteps;
            return this;
        }

        public final void setResolutionSteps(String resolutionSteps) {
            this.resolutionSteps = resolutionSteps;
        }

        public final Collection<? extends Collection<String>> getTargetFrames() {
            if (this.targetFrames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetFrames;
        }

        @Override
        public final Builder targetFrames(Collection<? extends Collection<String>> targetFrames) {
            this.targetFrames = TargetFramesCopier.copy(targetFrames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFrames(Collection<String> ... targetFrames) {
            this.targetFrames((Collection<? extends Collection<String>>)Arrays.asList(targetFrames));
            return this;
        }

        public final void setTargetFrames(Collection<? extends Collection<String>> targetFrames) {
            this.targetFrames = TargetFramesCopier.copy(targetFrames);
        }

        public final Double getThresholdPercent() {
            return this.thresholdPercent;
        }

        @Override
        public final Builder thresholdPercent(Double thresholdPercent) {
            this.thresholdPercent = thresholdPercent;
            return this;
        }

        public final void setThresholdPercent(Double thresholdPercent) {
            this.thresholdPercent = thresholdPercent;
        }

        public Pattern build() {
            return new Pattern(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Pattern> {
        public Builder countersToAggregate(Collection<String> var1);

        public Builder countersToAggregate(String ... var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder resolutionSteps(String var1);

        public Builder targetFrames(Collection<? extends Collection<String>> var1);

        public Builder targetFrames(Collection<String> ... var1);

        public Builder thresholdPercent(Double var1);
    }
}

