/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the getProfileRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<GetProfileRequest.Builder, GetProfileRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProfileRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetProfileRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetProfileRequest::maxDepth)).setter(setter(Builder::maxDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxDepth").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProfileRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("period").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProfileRequest::profilingGroupName)).setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetProfileRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, END_TIME_FIELD,
            MAX_DEPTH_FIELD, PERIOD_FIELD, PROFILING_GROUP_NAME_FIELD, START_TIME_FIELD));

    private final String accept;

    private final Instant endTime;

    private final Integer maxDepth;

    private final String period;

    private final String profilingGroupName;

    private final Instant startTime;

    private GetProfileRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.endTime = builder.endTime;
        this.maxDepth = builder.maxDepth;
        this.period = builder.period;
        this.profilingGroupName = builder.profilingGroupName;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The format of the profile to return. You can choose <code>application/json</code> or the default
     * <code>application/x-amzn-ion</code>.
     * </p>
     * 
     * @return The format of the profile to return. You can choose <code>application/json</code> or the default
     *         <code>application/x-amzn-ion</code>.
     */
    public String accept() {
        return accept;
    }

    /**
     * <p/>
     * <p>
     * You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>, and
     * <code>endTime</code>.
     * </p>
     * 
     * @return <p>
     *         You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>,
     *         and <code>endTime</code>.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum depth of the graph.
     * </p>
     * 
     * @return The maximum depth of the graph.
     */
    public Integer maxDepth() {
        return maxDepth;
    }

    /**
     * <p>
     * The period of the profile to get. The time range must be in the past and not longer than one week.
     * </p>
     * <p>
     * You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>, and
     * <code>endTime</code>.
     * </p>
     * 
     * @return The period of the profile to get. The time range must be in the past and not longer than one week. </p>
     *         <p>
     *         You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>,
     *         and <code>endTime</code>.
     */
    public String period() {
        return period;
    }

    /**
     * <p>
     * The name of the profiling group to get.
     * </p>
     * 
     * @return The name of the profiling group to get.
     */
    public String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The start time of the profile to get.
     * </p>
     * <p>
     * You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>, and
     * <code>endTime</code>.
     * </p>
     * 
     * @return The start time of the profile to get.</p>
     *         <p>
     *         You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>,
     *         and <code>endTime</code>.
     */
    public Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileRequest)) {
            return false;
        }
        GetProfileRequest other = (GetProfileRequest) obj;
        return Objects.equals(accept(), other.accept()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxDepth(), other.maxDepth()) && Objects.equals(period(), other.period())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetProfileRequest").add("Accept", accept()).add("EndTime", endTime())
                .add("MaxDepth", maxDepth()).add("Period", period()).add("ProfilingGroupName", profilingGroupName())
                .add("StartTime", startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxDepth":
            return Optional.ofNullable(clazz.cast(maxDepth()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileRequest, T> g) {
        return obj -> g.apply((GetProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetProfileRequest> {
        /**
         * <p>
         * The format of the profile to return. You can choose <code>application/json</code> or the default
         * <code>application/x-amzn-ion</code>.
         * </p>
         * 
         * @param accept
         *        The format of the profile to return. You can choose <code>application/json</code> or the default
         *        <code>application/x-amzn-ion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p/>
         * <p>
         * You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>, and
         * <code>endTime</code>.
         * </p>
         * 
         * @param endTime
         *        <p>
         *        You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>,
         *        and <code>endTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum depth of the graph.
         * </p>
         * 
         * @param maxDepth
         *        The maximum depth of the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDepth(Integer maxDepth);

        /**
         * <p>
         * The period of the profile to get. The time range must be in the past and not longer than one week.
         * </p>
         * <p>
         * You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>, and
         * <code>endTime</code>.
         * </p>
         * 
         * @param period
         *        The period of the profile to get. The time range must be in the past and not longer than one week.
         *        </p>
         *        <p>
         *        You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>,
         *        and <code>endTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(String period);

        /**
         * <p>
         * The name of the profiling group to get.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The start time of the profile to get.
         * </p>
         * <p>
         * You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>, and
         * <code>endTime</code>.
         * </p>
         * 
         * @param startTime
         *        The start time of the profile to get.</p>
         *        <p>
         *        You must specify exactly two of the following parameters: <code>startTime</code>, <code>period</code>,
         *        and <code>endTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private String accept;

        private Instant endTime;

        private Integer maxDepth;

        private String period;

        private String profilingGroupName;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileRequest model) {
            super(model);
            accept(model.accept);
            endTime(model.endTime);
            maxDepth(model.maxDepth);
            period(model.period);
            profilingGroupName(model.profilingGroupName);
            startTime(model.startTime);
        }

        public final String getAccept() {
            return accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getMaxDepth() {
            return maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        public final String getPeriod() {
            return period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileRequest build() {
            return new GetProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
