/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the createProfiliingGroupRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProfilingGroupRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<CreateProfilingGroupRequest.Builder, CreateProfilingGroupRequest> {
    private static final SdkField<AgentOrchestrationConfig> AGENT_ORCHESTRATION_CONFIG_FIELD = SdkField
            .<AgentOrchestrationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProfilingGroupRequest::agentOrchestrationConfig))
            .setter(setter(Builder::agentOrchestrationConfig)).constructor(AgentOrchestrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentOrchestrationConfig").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProfilingGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProfilingGroupRequest::profilingGroupName)).setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGENT_ORCHESTRATION_CONFIG_FIELD, CLIENT_TOKEN_FIELD, PROFILING_GROUP_NAME_FIELD));

    private final AgentOrchestrationConfig agentOrchestrationConfig;

    private final String clientToken;

    private final String profilingGroupName;

    private CreateProfilingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentOrchestrationConfig = builder.agentOrchestrationConfig;
        this.clientToken = builder.clientToken;
        this.profilingGroupName = builder.profilingGroupName;
    }

    /**
     * <p>
     * The agent orchestration configuration.
     * </p>
     * 
     * @return The agent orchestration configuration.
     */
    public AgentOrchestrationConfig agentOrchestrationConfig() {
        return agentOrchestrationConfig;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * <p>
     * This parameter specifies a unique identifier for the new profiling group that helps ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
     *         <p>
     *         This parameter specifies a unique identifier for the new profiling group that helps ensure idempotency.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the profiling group.
     * </p>
     * 
     * @return The name of the profiling group.
     */
    public String profilingGroupName() {
        return profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentOrchestrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfilingGroupRequest)) {
            return false;
        }
        CreateProfilingGroupRequest other = (CreateProfilingGroupRequest) obj;
        return Objects.equals(agentOrchestrationConfig(), other.agentOrchestrationConfig())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(profilingGroupName(), other.profilingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProfilingGroupRequest").add("AgentOrchestrationConfig", agentOrchestrationConfig())
                .add("ClientToken", clientToken()).add("ProfilingGroupName", profilingGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentOrchestrationConfig":
            return Optional.ofNullable(clazz.cast(agentOrchestrationConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfilingGroupRequest, T> g) {
        return obj -> g.apply((CreateProfilingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProfilingGroupRequest> {
        /**
         * <p>
         * The agent orchestration configuration.
         * </p>
         * 
         * @param agentOrchestrationConfig
         *        The agent orchestration configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig);

        /**
         * <p>
         * The agent orchestration configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link AgentOrchestrationConfig.Builder} avoiding the
         * need to create one manually via {@link AgentOrchestrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgentOrchestrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #agentOrchestrationConfig(AgentOrchestrationConfig)}.
         * 
         * @param agentOrchestrationConfig
         *        a consumer that will call methods on {@link AgentOrchestrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentOrchestrationConfig(AgentOrchestrationConfig)
         */
        default Builder agentOrchestrationConfig(Consumer<AgentOrchestrationConfig.Builder> agentOrchestrationConfig) {
            return agentOrchestrationConfig(AgentOrchestrationConfig.builder().applyMutation(agentOrchestrationConfig).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * <p>
         * This parameter specifies a unique identifier for the new profiling group that helps ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
         *        <p>
         *        This parameter specifies a unique identifier for the new profiling group that helps ensure
         *        idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the profiling group.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private AgentOrchestrationConfig agentOrchestrationConfig;

        private String clientToken;

        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfilingGroupRequest model) {
            super(model);
            agentOrchestrationConfig(model.agentOrchestrationConfig);
            clientToken(model.clientToken);
            profilingGroupName(model.profilingGroupName);
        }

        public final AgentOrchestrationConfig.Builder getAgentOrchestrationConfig() {
            return agentOrchestrationConfig != null ? agentOrchestrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig;
            return this;
        }

        public final void setAgentOrchestrationConfig(AgentOrchestrationConfig.BuilderImpl agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig != null ? agentOrchestrationConfig.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfilingGroupRequest build() {
            return new CreateProfilingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
