/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeMarshaller;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.Input;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceMetadata;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.model.service.XmlNamespace;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;

public final class Utils {
    private Utils() {
    }

    public static boolean isScalar(Shape shape) {
        return !Utils.isListShape(shape) && !Utils.isStructure(shape) && !Utils.isMapShape(shape);
    }

    public static boolean isStructure(Shape shape) {
        return shape.getType().equals("structure");
    }

    public static boolean isListShape(Shape shape) {
        return shape.getType().equals("list");
    }

    public static boolean isMapShape(Shape shape) {
        return shape.getType().equals("map");
    }

    public static boolean isEnumShape(Shape shape) {
        return shape.getEnumValues() != null;
    }

    public static boolean isExceptionShape(Shape shape) {
        return shape.isException() || shape.isFault();
    }

    public static boolean isOrContainsEnumShape(Shape shape, Map<String, Shape> allShapes) {
        boolean isEnum = Utils.isEnumShape(shape);
        boolean isMapWithEnumMember = Utils.isMapShape(shape) && (Utils.isEnumShape(allShapes.get(shape.getMapKeyType().getShape())) || Utils.isEnumShape(allShapes.get(shape.getMapValueType().getShape())));
        boolean isListWithEnumMember = Utils.isListShape(shape) && Utils.isEnumShape(allShapes.get(shape.getListMember().getShape()));
        return isEnum || isMapWithEnumMember || isListWithEnumMember;
    }

    public static boolean isOrContainsEnum(MemberModel member) {
        boolean isEnum = member.getEnumType() != null;
        return isEnum || Utils.isMapWithEnumShape(member) || Utils.isListWithEnumShape(member);
    }

    public static boolean isListWithEnumShape(MemberModel member) {
        return member.isList() && member.getListModel().getListMemberModel().getEnumType() != null;
    }

    public static boolean isMapWithEnumShape(MemberModel member) {
        return member.isMap() && (Utils.isMapKeyWithEnumShape(member.getMapModel()) || Utils.isMapValueWithEnumShape(member.getMapModel()));
    }

    public static boolean isMapKeyWithEnumShape(MapModel mapModel) {
        return mapModel.getKeyModel().getEnumType() != null;
    }

    public static boolean isMapValueWithEnumShape(MapModel mapModel) {
        return mapModel.getValueModel().getEnumType() != null;
    }

    public static String unCapitalize(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        StringBuilder sb = new StringBuilder(name.length());
        int i = 0;
        do {
            sb.append(Character.toLowerCase(name.charAt(i++)));
        } while (i < name.length() && Character.isUpperCase(name.charAt(i)) && (i >= name.length() - 1 || !Character.isLowerCase(name.charAt(i + 1))));
        sb.append(name.substring(i));
        return sb.toString();
    }

    public static String capitalize(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return name.length() < 2 ? StringUtils.upperCase((String)name) : StringUtils.upperCase((String)name.substring(0, 1)) + name.substring(1);
    }

    public static String removeLeading(String str, String toRemove) {
        if (str == null) {
            return null;
        }
        if (str.startsWith(toRemove)) {
            return str.substring(toRemove.length());
        }
        return str;
    }

    public static String removeTrailing(String str, String toRemove) {
        if (str == null) {
            return null;
        }
        if (str.endsWith(toRemove)) {
            return str.substring(0, str.length() - toRemove.length());
        }
        return str;
    }

    public static String getFileNamePrefix(ServiceModel serviceModel) {
        return String.format("%s-%s", serviceModel.getMetadata().getEndpointPrefix(), serviceModel.getMetadata().getApiVersion());
    }

    public static String directoryToPackage(String directoryPath) {
        return directoryPath.replace('/', '.');
    }

    public static String packageToDirectory(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String getDefaultEndpointWithoutHttpProtocol(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        if (endpoint.startsWith("http://")) {
            return endpoint.substring("http://".length());
        }
        if (endpoint.startsWith("https://")) {
            return endpoint.substring("https://".length());
        }
        return endpoint;
    }

    public static File createDirectory(String path) {
        if (Utils.isNullOrEmpty(path)) {
            throw new IllegalArgumentException("Invalid path directory. Path directory cannot be null or empty");
        }
        File dir = new File(path);
        Utils.createDirectory(dir);
        return dir;
    }

    public static void createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Not able to create directory. " + dir.getAbsolutePath());
        }
    }

    public static File createFile(String dir, String fileName) throws IOException {
        if (Utils.isNullOrEmpty(fileName)) {
            throw new IllegalArgumentException("Invalid file name. File name cannot be null or empty");
        }
        Utils.createDirectory(dir);
        File file = new File(dir, fileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Not able to create file . " + file.getAbsolutePath());
        }
        return file;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static void closeQuietly(Closeable closeable) {
        IoUtils.closeQuietly((AutoCloseable)closeable, null);
    }

    public static InputStream getRequiredResourceAsStream(Class<?> clzz, String location) {
        InputStream resourceStream = clzz.getResourceAsStream(location);
        if (resourceStream == null) {
            if (!location.startsWith("/")) {
                resourceStream = clzz.getResourceAsStream("/" + location);
            }
            if (resourceStream == null) {
                throw new RuntimeException("Resource file was not found at location " + location);
            }
        }
        return resourceStream;
    }

    public static ShapeModel findShapeModelByC2jName(IntermediateModel intermediateModel, String shapeC2jName) throws IllegalArgumentException {
        ShapeModel shapeModel = Utils.findShapeModelByC2jNameIfExists(intermediateModel, shapeC2jName);
        if (shapeModel != null) {
            return shapeModel;
        }
        throw new IllegalArgumentException(shapeC2jName + " shape (c2j name) does not exist in the intermediate model.");
    }

    public static ShapeModel findShapeModelByC2jNameIfExists(IntermediateModel intermediateModel, String shapeC2jName) {
        for (ShapeModel shape : intermediateModel.getShapes().values()) {
            if (!shape.getC2jName().equals(shapeC2jName)) continue;
            return shape;
        }
        return null;
    }

    public static List<ShapeModel> findShapesByC2jName(IntermediateModel intermediateModel, String shapeC2jName) {
        return intermediateModel.getShapes().values().stream().filter(s -> s.getC2jName().equals(shapeC2jName)).collect(Collectors.toList());
    }

    public static ShapeMarshaller createInputShapeMarshaller(ServiceMetadata service, Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("The operation parameter must be specified!");
        }
        ShapeMarshaller marshaller = new ShapeMarshaller().withAction(operation.getName()).withVerb(operation.getHttp().getMethod()).withRequestUri(operation.getHttp().getRequestUri());
        Input input = operation.getInput();
        if (input != null) {
            marshaller.setLocationName(input.getLocationName());
            XmlNamespace xmlNamespace = input.getXmlNamespace();
            if (xmlNamespace != null) {
                marshaller.setXmlNameSpaceUri(xmlNamespace.getUri());
            }
        }
        if (Metadata.isNotRestProtocol(service.getProtocol())) {
            marshaller.setTarget(StringUtils.isEmpty((CharSequence)service.getTargetPrefix()) ? operation.getName() : service.getTargetPrefix() + "." + operation.getName());
        }
        return marshaller;
    }
}

