/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.client.traits.HttpChecksumTrait;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Validate;

public class ServiceClientConfigurationUtils {
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final ClassName configurationClassName;
    private final ClassName configurationBuilderClassName;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final List<Field> fields;

    public ServiceClientConfigurationUtils(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        String serviceId = model.getMetadata().getServiceName();
        this.configurationClassName = ClassName.get((String)basePackage, (String)(serviceId + "ServiceClientConfiguration"), (String[])new String[0]);
        this.configurationBuilderClassName = ClassName.get((String)model.getMetadata().getFullClientInternalPackageName(), (String)(serviceId + "ServiceClientConfigurationBuilder"), (String[])new String[0]);
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(model);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.fields = this.fields(model);
    }

    public ClassName serviceClientConfigurationClassName() {
        return this.configurationClassName;
    }

    public ClassName serviceClientConfigurationBuilderClassName() {
        return this.configurationBuilderClassName;
    }

    public List<Field> serviceClientConfigurationFields() {
        return Collections.unmodifiableList(this.fields);
    }

    private List<Field> fields(IntermediateModel model) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(this.overrideConfigurationField(), this.endpointOverrideField(), this.endpointProviderField(), this.regionField(), this.credentialsProviderField(), this.authSchemesField(), this.authSchemeProviderField()));
        fields.addAll(this.addCustomClientParams(model));
        fields.addAll(this.addModeledIdentityProviders(model));
        fields.addAll(this.addCustomClientConfigParams(model));
        return fields;
    }

    private List<Field> addModeledIdentityProviders(IntermediateModel model) {
        ArrayList<Field> identityProviderFields = new ArrayList<Field>();
        if (AuthUtils.usesBearerAuth(model)) {
            identityProviderFields.add(this.tokenIdentityProviderField());
        }
        return identityProviderFields;
    }

    private Field tokenIdentityProviderField() {
        ParameterizedTypeName tokenIdentityProviderType = ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(TokenIdentity.class)});
        return this.fieldBuilder("tokenProvider", (TypeName)tokenIdentityProviderType).doc("token provider").isInherited(false).localSetter(this.basicLocalSetterCode("tokenProvider")).localGetter(this.basicLocalGetterCode("tokenProvider")).configSetter(this.basicConfigSetterCode((ClientOption<?>)AwsClientOption.TOKEN_IDENTITY_PROVIDER, "tokenProvider")).configGetter(this.basicConfigGetterCode((ClientOption<?>)AwsClientOption.TOKEN_IDENTITY_PROVIDER)).build();
    }

    private List<Field> addCustomClientParams(IntermediateModel model) {
        ArrayList<Field> customClientParamFields = new ArrayList<Field>();
        if (model.getCustomizationConfig() != null && model.getCustomizationConfig().getCustomClientContextParams() != null) {
            model.getCustomizationConfig().getCustomClientContextParams().forEach((n, m) -> {
                String paramName = this.endpointRulesSpecUtils.paramMethodName((String)n);
                String keyName = model.getNamingStrategy().getEnumValueName((String)n);
                TypeName type = this.endpointRulesSpecUtils.toJavaType(m.getType());
                customClientParamFields.add(this.fieldBuilder(paramName, type).doc(m.getDocumentation()).isInherited(false).localSetter(this.basicLocalSetterCode(paramName)).localGetter(this.basicLocalGetterCode(paramName)).configSetter(this.customClientConfigParamSetter(paramName, keyName)).configGetter(this.customClientConfigParamGetter(keyName)).build());
            });
        }
        return customClientParamFields;
    }

    private Field overrideConfigurationField() {
        return this.fieldBuilder("overrideConfiguration", ClientOverrideConfiguration.class).doc("client override configuration").localSetter(this.basicLocalSetterCode("overrideConfiguration")).localGetter(this.basicLocalGetterCode("overrideConfiguration")).configSetter(this.overrideConfigurationConfigSetter()).configGetter(this.overrideConfigurationConfigGetter()).build();
    }

    private CodeBlock overrideConfigurationConfigSetter() {
        return CodeBlock.builder().addStatement("config.putAll(overrideConfiguration)", new Object[]{SdkClientConfiguration.class}).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock overrideConfigurationConfigGetter() {
        return CodeBlock.of((String)"return config.asOverrideConfigurationBuilder().build();", (Object[])new Object[0]);
    }

    private Field endpointOverrideField() {
        return this.fieldBuilder("endpointOverride", URI.class).doc("endpoint override").localSetter(this.basicLocalSetterCode("endpointOverride")).localGetter(this.basicLocalGetterCode("endpointOverride")).configSetter(this.endpointOverrideConfigSetter()).configGetter(this.endpointOverrideConfigGetter()).build();
    }

    private CodeBlock endpointOverrideConfigSetter() {
        return CodeBlock.builder().beginControlFlow("if (endpointOverride != null)", new Object[0]).addStatement("config.option($T.CLIENT_ENDPOINT_PROVIDER, $T.forEndpointOverride(endpointOverride))", new Object[]{SdkClientOption.class, ClientEndpointProvider.class}).nextControlFlow("else", new Object[0]).addStatement("config.option($T.CLIENT_ENDPOINT_PROVIDER, null)", new Object[]{SdkClientOption.class}).endControlFlow().addStatement("return this", new Object[0]).build();
    }

    private CodeBlock endpointOverrideConfigGetter() {
        return CodeBlock.builder().addStatement("$T clientEndpoint = config.option($T.CLIENT_ENDPOINT_PROVIDER)", new Object[]{ClientEndpointProvider.class, SdkClientOption.class}).beginControlFlow("if (clientEndpoint != null && clientEndpoint.isEndpointOverridden())", new Object[0]).addStatement("return clientEndpoint.clientEndpoint()", new Object[0]).endControlFlow().addStatement("return null", new Object[0]).build();
    }

    private Field endpointProviderField() {
        return this.fieldBuilder("endpointProvider", EndpointProvider.class).doc("endpoint provider").localSetter(this.basicLocalSetterCode("endpointProvider")).localGetter(this.basicLocalGetterCode("endpointProvider")).configSetter(this.basicConfigSetterCode((ClientOption<?>)SdkClientOption.ENDPOINT_PROVIDER, "endpointProvider")).configGetter(this.basicConfigGetterCode((ClientOption<?>)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }

    private Field regionField() {
        return this.fieldBuilder("region", Region.class).doc("AWS region").localSetter(this.basicLocalSetterCode("region")).localGetter(this.basicLocalGetterCode("region")).configSetter(this.basicConfigSetterCode((ClientOption<?>)AwsClientOption.AWS_REGION, "region")).configGetter(this.basicConfigGetterCode((ClientOption<?>)AwsClientOption.AWS_REGION)).build();
    }

    private Field credentialsProviderField() {
        ParameterizedTypeName awsIdentityProviderType = ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(AwsCredentialsIdentity.class)});
        return this.fieldBuilder("credentialsProvider", (TypeName)awsIdentityProviderType).doc("credentials provider").localSetter(this.basicLocalSetterCode("credentialsProvider")).localGetter(this.basicLocalGetterCode("credentialsProvider")).configSetter(this.basicConfigSetterCode((ClientOption<?>)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, "credentialsProvider")).configGetter(this.basicConfigGetterCode((ClientOption<?>)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).build();
    }

    private Field authSchemesField() {
        ParameterizedTypeName authSchemeGenericType = ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        ParameterizedTypeName authSchemesType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), authSchemeGenericType});
        return this.fieldBuilder("authSchemes", (TypeName)authSchemesType).doc("auth schemes").setterSpec(this.authSchemesSetterSpec()).localSetter(this.authSchemesLocalSetter()).localGetter(this.authSchemesLocalGetter()).configSetter(this.authSchemesConfigSetter()).configGetter(this.authSchemeConfigGetter()).build();
    }

    private MethodSpec authSchemesSetterSpec() {
        ParameterizedTypeName authScheme = ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        return MethodSpec.methodBuilder((String)"putAuthScheme").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addParameter((TypeName)authScheme, "authScheme", new javax.lang.model.element.Modifier[0]).returns((TypeName)this.configurationClassName.nestedClass("Builder")).build();
    }

    private CodeBlock authSchemesLocalSetter() {
        return CodeBlock.builder().beginControlFlow("if (this.authSchemes == null)", new Object[0]).addStatement("this.authSchemes = new HashMap<>()", new Object[0]).endControlFlow().addStatement("this.authSchemes.put(authScheme.schemeId(), authScheme)", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock authSchemesLocalGetter() {
        return CodeBlock.builder().addStatement("return $1T.unmodifiableMap(authSchemes == null ? $1T.emptyMap() : authSchemes)", new Object[]{Collections.class}).build();
    }

    private CodeBlock authSchemesConfigSetter() {
        return CodeBlock.builder().addStatement("config.computeOptionIfAbsent($T.AUTH_SCHEMES, $T::new).put(authScheme.schemeId(), authScheme)", new Object[]{SdkClientOption.class, HashMap.class}).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock authSchemeConfigGetter() {
        return CodeBlock.builder().addStatement("$T<$T, $T<?>> authSchemes = config.option($T.AUTH_SCHEMES)", new Object[]{Map.class, String.class, AuthScheme.class, SdkClientOption.class}).addStatement("return $1T.unmodifiableMap(authSchemes == null ? $1T.emptyMap() : authSchemes)", new Object[]{Collections.class}).build();
    }

    private Field authSchemeProviderField() {
        return this.fieldBuilder("authSchemeProvider", (TypeName)this.authSchemeSpecUtils.providerInterfaceName()).doc("auth scheme provider").isInherited(false).localSetter(this.basicLocalSetterCode("authSchemeProvider")).localGetter(this.basicLocalGetterCode("authSchemeProvider")).configSetter(this.basicConfigSetterCode((ClientOption<?>)SdkClientOption.AUTH_SCHEME_PROVIDER, "authSchemeProvider")).configGetter(this.authSchemeProviderConfigGetter()).build();
    }

    private CodeBlock authSchemeProviderConfigGetter() {
        return CodeBlock.builder().addStatement("$T result = config.option($T.AUTH_SCHEME_PROVIDER)", new Object[]{AuthSchemeProvider.class, SdkClientOption.class}).beginControlFlow("if (result == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $1T.isInstanceOf($2T.class, result, \"Expected an instance of \" + $2T.class.getSimpleName())", new Object[]{Validate.class, this.authSchemeSpecUtils.providerInterfaceName()}).build();
    }

    private CodeBlock customClientConfigParamSetter(String parameterName, String keyName) {
        return CodeBlock.builder().addStatement("config.option($1T.CLIENT_CONTEXT_PARAMS, config.computeOptionIfAbsent($1T.CLIENT_CONTEXT_PARAMS, $2T::empty).toBuilder().put($3T.$4N, $5N).build())", new Object[]{SdkClientOption.class, AttributeMap.class, this.endpointRulesSpecUtils.clientContextParamsName(), keyName, parameterName}).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock customClientConfigParamGetter(String keyName) {
        return CodeBlock.builder().addStatement("return config.computeOptionIfAbsent($T.CLIENT_CONTEXT_PARAMS, $T::empty)\n.get($T.$N)", new Object[]{SdkClientOption.class, AttributeMap.class, this.endpointRulesSpecUtils.clientContextParamsName(), keyName}).build();
    }

    private CodeBlock basicLocalSetterCode(String fieldName) {
        return CodeBlock.builder().addStatement("this.$1N = $1N", new Object[]{fieldName}).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock basicLocalGetterCode(String fieldName) {
        return CodeBlock.of((String)"return $N;", (Object[])new Object[]{fieldName});
    }

    private CodeBlock basicConfigSetterCode(ClientOption<?> option, String parameterName) {
        return CodeBlock.builder().addStatement("config.option($T.$N, $N)", new Object[]{option.getClass(), ServiceClientConfigurationUtils.fieldName(option), parameterName}).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock basicConfigGetterCode(ClientOption<?> option) {
        return CodeBlock.of((String)"return config.option($T.$N);", (Object[])new Object[]{option.getClass(), ServiceClientConfigurationUtils.fieldName(option)});
    }

    public FieldBuilder fieldBuilder(String name, TypeName type) {
        return new FieldBuilder().name(name).type(type);
    }

    public FieldBuilder fieldBuilder(String name, Class<?> type) {
        return new FieldBuilder().name(name).type(type);
    }

    private static String fieldName(Object fieldObject) {
        java.lang.reflect.Field[] allFields;
        for (java.lang.reflect.Field field : allFields = fieldObject.getClass().getFields()) {
            Object currentFieldObject;
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            try {
                currentFieldObject = field.get(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            boolean isWantedField = fieldObject.equals(currentFieldObject);
            if (!isWantedField) continue;
            return field.getName();
        }
        throw new NoSuchElementException(String.format("cannot find constant %s in class %s", fieldObject, fieldObject.getClass().getName()));
    }

    private List<Field> addCustomClientConfigParams(IntermediateModel model) {
        ArrayList<Field> customClientParamFields = new ArrayList<Field>();
        if (HttpChecksumTrait.hasRequestAlgorithmMember(model) && HttpChecksumTrait.hasResponseAlgorithms(model)) {
            customClientParamFields.add(this.createChecksumConfigField("responseChecksumValidation", ResponseChecksumValidation.class, "client behavior for response checksum validation", SdkClientOption.class, "RESPONSE_CHECKSUM_VALIDATION"));
            customClientParamFields.add(this.createChecksumConfigField("requestChecksumCalculation", RequestChecksumCalculation.class, "client behavior for request checksum calculation", SdkClientOption.class, "REQUEST_CHECKSUM_CALCULATION"));
        }
        return customClientParamFields;
    }

    private Field createChecksumConfigField(String fieldName, Class<?> fieldType, String docString, Class<?> optionClass, String optionName) {
        return this.fieldBuilder(fieldName, fieldType).doc(docString).isInherited(false).localSetter(this.basicLocalSetterCode(fieldName)).localGetter(this.basicLocalGetterCode(fieldName)).configSetter(CodeBlock.builder().addStatement("config.option($1T.$2L, $3L)", new Object[]{optionClass, optionName, fieldName}).addStatement("return this", new Object[0]).build()).configGetter(CodeBlock.builder().addStatement("return config.option($1T.$2L)", new Object[]{optionClass, optionName}).build()).build();
    }

    private class FieldBuilder {
        private String name;
        private TypeName type;
        private String doc;
        private Boolean isInherited = true;
        private MethodSpec setterSpec;
        private MethodSpec getterSpec;
        private CodeBlock localSetter;
        private CodeBlock localGetter;
        private CodeBlock configSetter;
        private CodeBlock configGetter;

        private FieldBuilder() {
        }

        public FieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FieldBuilder type(Class<?> type) {
            this.type = ClassName.get(type);
            return this;
        }

        public FieldBuilder type(TypeName type) {
            this.type = type;
            return this;
        }

        public FieldBuilder doc(String doc) {
            this.doc = doc;
            return this;
        }

        public FieldBuilder isInherited(Boolean inherited) {
            this.isInherited = inherited;
            return this;
        }

        public FieldBuilder setterSpec(MethodSpec setterSpec) {
            this.setterSpec = setterSpec;
            return this;
        }

        public FieldBuilder getterSpec(MethodSpec getterSpec) {
            this.getterSpec = getterSpec;
            return this;
        }

        public FieldBuilder localSetter(CodeBlock localSetter) {
            this.localSetter = localSetter;
            return this;
        }

        public FieldBuilder localGetter(CodeBlock localGetter) {
            this.localGetter = localGetter;
            return this;
        }

        public FieldBuilder configSetter(CodeBlock configSetter) {
            this.configSetter = configSetter;
            return this;
        }

        public FieldBuilder configGetter(CodeBlock configGetter) {
            this.configGetter = configGetter;
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }

    public class Field {
        private final String name;
        private final TypeName type;
        private final String doc;
        private final boolean isInherited;
        private final MethodSpec setterSpec;
        private final MethodSpec getterSpec;
        private final MethodSpec localSetter;
        private final MethodSpec localGetter;
        private final MethodSpec configSetter;
        private final MethodSpec configGetter;

        Field(FieldBuilder builder) {
            this.name = (String)Validate.paramNotNull((Object)builder.name, (String)"name");
            this.type = (TypeName)Validate.paramNotNull((Object)builder.type, (String)"type");
            this.doc = (String)Validate.paramNotNull((Object)builder.doc, (String)"doc");
            this.isInherited = (Boolean)Validate.paramNotNull((Object)builder.isInherited, (String)"isInherited");
            Validate.paramNotNull((Object)builder.localSetter, (String)"localSetter");
            Validate.paramNotNull((Object)builder.localGetter, (String)"localGetter");
            Validate.paramNotNull((Object)builder.configSetter, (String)"configSetter");
            Validate.paramNotNull((Object)builder.configGetter, (String)"configGetter");
            this.setterSpec = this.setterSpec(builder.setterSpec);
            this.getterSpec = this.getterSpec(builder.getterSpec);
            this.localSetter = this.setterSpec.toBuilder().addCode(builder.localSetter).build();
            this.localGetter = this.getterSpec.toBuilder().addCode(builder.localGetter).build();
            this.configSetter = this.setterSpec.toBuilder().addCode(builder.configSetter).build();
            this.configGetter = this.getterSpec.toBuilder().addCode(builder.configGetter).build();
        }

        private MethodSpec setterSpec(MethodSpec setterSpec) {
            if (setterSpec != null) {
                return setterSpec;
            }
            return MethodSpec.methodBuilder((String)this.name).addJavadoc("Sets the value for " + this.doc, new Object[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).returns((TypeName)ServiceClientConfigurationUtils.this.configurationClassName.nestedClass("Builder")).addParameter(this.type, this.name, new javax.lang.model.element.Modifier[0]).build();
        }

        private MethodSpec getterSpec(MethodSpec getterSpec) {
            if (getterSpec != null) {
                return getterSpec;
            }
            return MethodSpec.methodBuilder((String)this.name).addJavadoc("Gets the value for " + this.doc, new Object[0]).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).returns(this.type).build();
        }

        public String name() {
            return this.name;
        }

        public TypeName type() {
            return this.type;
        }

        public String doc() {
            return this.doc;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public MethodSpec setterSpec() {
            return this.setterSpec;
        }

        public MethodSpec getterSpec() {
            return this.getterSpec;
        }

        public MethodSpec localSetter() {
            return this.localSetter;
        }

        public MethodSpec localGetter() {
            return this.localGetter;
        }

        public MethodSpec configSetter() {
            return this.configSetter;
        }

        public MethodSpec configGetter() {
            return this.configGetter;
        }
    }
}

