/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.naming;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.config.customization.UnderscoresInNameBehavior;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static final Logger log = Logger.loggerFor(DefaultNamingStrategy.class);
    private static final Pattern VALID_IDENTIFIER_NAME = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final String COLLISION_DISAMBIGUATION_PREFIX = "Default";
    private static final Set<String> RESERVED_KEYWORDS;
    private static final Set<String> RESERVED_EXCEPTION_METHOD_NAMES;
    private static final Set<Object> RESERVED_STRUCTURE_METHOD_NAMES;
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;

    public DefaultNamingStrategy(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
        this.customizationConfig = customizationConfig == null ? CustomizationConfig.create() : customizationConfig;
    }

    private static boolean isJavaKeyword(String word) {
        return RESERVED_KEYWORDS.contains(word) || RESERVED_KEYWORDS.contains(StringUtils.lowerCase((String)word));
    }

    @Override
    public String getServiceName() {
        String baseName = this.serviceId();
        baseName = CodegenNamingUtils.pascalCase((String)baseName);
        baseName = DefaultNamingStrategy.removeRedundantPrefixesAndSuffixes(baseName);
        return baseName;
    }

    @Override
    public String getServiceNameForEnvironmentVariables() {
        String baseName = this.serviceId();
        baseName = baseName.replace(' ', '_');
        baseName = StringUtils.upperCase((String)baseName);
        return baseName;
    }

    @Override
    public String getServiceNameForSystemProperties() {
        return this.getServiceName();
    }

    @Override
    public String getServiceNameForProfileFile() {
        return StringUtils.lowerCase((String)this.getServiceNameForEnvironmentVariables());
    }

    private String serviceId() {
        return Stream.of(this.serviceModel.getMetadata().getServiceId()).filter(Objects::nonNull).filter(s -> !s.trim().isEmpty()).findFirst().orElseThrow(() -> new IllegalStateException("ServiceId is missing in the c2j model."));
    }

    private static String removeRedundantPrefixesAndSuffixes(String baseName) {
        baseName = Utils.removeLeading(baseName, "amazon");
        baseName = Utils.removeLeading(baseName, "aws");
        baseName = Utils.removeTrailing(baseName, "service");
        return baseName;
    }

    @Override
    public String getClientPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s");
    }

    @Override
    public String getModelPackageName(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null && this.customizationConfig.getShareModelConfig().getShareModelWith() != null) {
            serviceName = this.customizationConfig.getShareModelConfig().getShareModelWith();
        }
        return this.getCustomizedPackageName(serviceName, "%s.model");
    }

    @Override
    public String getTransformPackageName(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null && this.customizationConfig.getShareModelConfig().getShareModelWith() != null) {
            serviceName = this.customizationConfig.getShareModelConfig().getShareModelWith();
        }
        return this.getCustomizedPackageName(serviceName, "%s.transform");
    }

    @Override
    public String getRequestTransformPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.transform");
    }

    @Override
    public String getPaginatorsPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.paginators");
    }

    @Override
    public String getWaitersPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.waiters");
    }

    @Override
    public String getEndpointRulesPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.endpoints");
    }

    @Override
    public String getAuthSchemePackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.auth.scheme");
    }

    @Override
    public String getJmesPathPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.jmespath");
    }

    @Override
    public String getBatchManagerPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.batchmanager");
    }

    @Override
    public String getSmokeTestPackageName(String serviceName) {
        return this.getCustomizedPackageName(this.concatServiceNameIfShareModel(serviceName), "%s.smoketests");
    }

    private String concatServiceNameIfShareModel(String serviceName) {
        if (this.customizationConfig.getShareModelConfig() != null) {
            return this.customizationConfig.getShareModelConfig().getShareModelWith() + "." + Optional.ofNullable(this.customizationConfig.getShareModelConfig().getPackageName()).orElse(serviceName);
        }
        return serviceName;
    }

    private String screamCase(String word) {
        return Stream.of(CodegenNamingUtils.splitOnWordBoundaries((String)word)).map(s -> s.toUpperCase(Locale.US)).collect(Collectors.joining("_"));
    }

    private String getCustomizedPackageName(String serviceName, String defaultPattern) {
        return String.format(defaultPattern, StringUtils.lowerCase((String)serviceName));
    }

    @Override
    public String getExceptionName(String errorShapeName) {
        String baseName = errorShapeName.endsWith("Fault") ? CodegenNamingUtils.pascalCase((String)errorShapeName.substring(0, errorShapeName.length() - "Fault".length())) + "Exception" : (errorShapeName.endsWith("Exception") ? CodegenNamingUtils.pascalCase((String)errorShapeName) : CodegenNamingUtils.pascalCase((String)errorShapeName) + "Exception");
        if (baseName.equals(this.getServiceName() + "Exception")) {
            return COLLISION_DISAMBIGUATION_PREFIX + baseName;
        }
        return baseName;
    }

    @Override
    public String getRequestClassName(String operationName) {
        String baseName = CodegenNamingUtils.pascalCase((String)operationName) + "Request";
        if (!operationName.equals(this.getServiceName())) {
            return baseName;
        }
        return COLLISION_DISAMBIGUATION_PREFIX + baseName;
    }

    @Override
    public String getResponseClassName(String operationName) {
        String baseName = CodegenNamingUtils.pascalCase((String)operationName) + "Response";
        if (!operationName.equals(this.getServiceName())) {
            return baseName;
        }
        return COLLISION_DISAMBIGUATION_PREFIX + baseName;
    }

    @Override
    public String getVariableName(String name) {
        if (DefaultNamingStrategy.isJavaKeyword(name) || RESERVED_STRUCTURE_METHOD_NAMES.contains(name) || RESERVED_EXCEPTION_METHOD_NAMES.contains(name)) {
            return Utils.unCapitalize(name + "Value");
        }
        return Utils.unCapitalize(name);
    }

    @Override
    public String getEnumValueName(String enumValue) {
        String result = enumValue;
        result = result.replace("textORcsv", "TEXT_OR_CSV");
        result = String.join((CharSequence)"_", CodegenNamingUtils.splitOnWordBoundaries((String)result));
        if (!(result = StringUtils.upperCase((String)result)).matches("^[A-Z][A-Z0-9_]*$")) {
            String attempt = result;
            log.warn(() -> "Invalid enum member generated for input '" + enumValue + "'. Best attempt: '" + attempt + "' If this enum is not customized out, the build will fail.");
        }
        return result;
    }

    @Override
    public String getShapeClassName(String shapeName) {
        return Utils.capitalize(shapeName);
    }

    @Override
    public String getFluentGetterMethodName(String memberName, Shape parentShape, Shape shape) {
        String getterMethodName = Utils.unCapitalize(memberName);
        getterMethodName = this.rewriteInvalidMemberName(getterMethodName, parentShape);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            getterMethodName = getterMethodName + "AsString";
            if (Utils.isListShape(shape) || Utils.isMapShape(shape)) {
                getterMethodName = getterMethodName + "s";
            }
        }
        return getterMethodName;
    }

    @Override
    public String getFluentEnumGetterMethodName(String memberName, Shape parentShape, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        String getterMethodName = Utils.unCapitalize(memberName);
        getterMethodName = this.rewriteInvalidMemberName(getterMethodName, parentShape);
        return getterMethodName;
    }

    @Override
    public String getExistenceCheckMethodName(String memberName, Shape parentShape) {
        String existenceCheckMethodName = Utils.unCapitalize(memberName);
        existenceCheckMethodName = this.rewriteInvalidMemberName(existenceCheckMethodName, parentShape);
        return String.format("has%s", Utils.capitalize(existenceCheckMethodName));
    }

    @Override
    public String getBeanStyleGetterMethodName(String memberName, Shape parentShape, Shape c2jShape) {
        String fluentGetterMethodName = Utils.isOrContainsEnumShape(c2jShape, this.serviceModel.getShapes()) ? this.getFluentEnumGetterMethodName(memberName, parentShape, c2jShape) : this.getFluentGetterMethodName(memberName, parentShape, c2jShape);
        return String.format("get%s", Utils.capitalize(fluentGetterMethodName));
    }

    @Override
    public String getBeanStyleSetterMethodName(String memberName, Shape parentShape, Shape c2jShape) {
        String beanStyleGetter = this.getBeanStyleGetterMethodName(memberName, parentShape, c2jShape);
        return String.format("set%s", beanStyleGetter.substring("get".length()));
    }

    @Override
    public String getFluentSetterMethodName(String memberName, Shape parentShape, Shape shape) {
        String setterMethodName = Utils.unCapitalize(memberName);
        setterMethodName = this.rewriteInvalidMemberName(setterMethodName, parentShape);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes()) && (Utils.isListShape(shape) || Utils.isMapShape(shape))) {
            setterMethodName = setterMethodName + "WithStrings";
        }
        return setterMethodName;
    }

    @Override
    public String getFluentEnumSetterMethodName(String memberName, Shape parentShape, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        String setterMethodName = Utils.unCapitalize(memberName);
        setterMethodName = this.rewriteInvalidMemberName(setterMethodName, parentShape);
        return setterMethodName;
    }

    @Override
    public String getSdkFieldFieldName(MemberModel memberModel) {
        return this.screamCase(memberModel.getName()) + "_FIELD";
    }

    @Override
    public String getUnionEnumTypeName(MemberModel memberModel) {
        return this.screamCase(memberModel.getName());
    }

    private String rewriteInvalidMemberName(String memberName, Shape parentShape) {
        if (DefaultNamingStrategy.isJavaKeyword(memberName) || this.isDisallowedNameForShape(memberName, parentShape)) {
            return Utils.unCapitalize(memberName + "Value");
        }
        return memberName;
    }

    private boolean isDisallowedNameForShape(String name, Shape parentShape) {
        if (parentShape.isUnion() && "type".equals(name)) {
            return true;
        }
        if (parentShape.isException()) {
            return RESERVED_EXCEPTION_METHOD_NAMES.contains(name);
        }
        return RESERVED_STRUCTURE_METHOD_NAMES.contains(name);
    }

    @Override
    public String getSigningName() {
        return Optional.ofNullable(this.serviceModel.getMetadata().getSigningName()).orElseGet(() -> this.serviceModel.getMetadata().getEndpointPrefix());
    }

    @Override
    public String getSigningNameForEnvironmentVariables() {
        return this.screamCase(this.getSigningName());
    }

    @Override
    public String getSigningNameForSystemProperties() {
        return CodegenNamingUtils.pascalCase((String)this.getSigningName());
    }

    @Override
    public void validateCustomerVisibleNaming(IntermediateModel trimmedModel) {
        Metadata metadata = trimmedModel.getMetadata();
        this.validateCustomerVisibleName(metadata.getSyncInterface(), "metadata-derived interface name");
        this.validateCustomerVisibleName(metadata.getSyncBuilderInterface(), "metadata-derived builder interface name");
        this.validateCustomerVisibleName(metadata.getAsyncInterface(), "metadata-derived async interface name");
        this.validateCustomerVisibleName(metadata.getAsyncBuilderInterface(), "metadata-derived async builder interface name");
        this.validateCustomerVisibleName(metadata.getBaseBuilderInterface(), "metadata-derived builder interface name");
        this.validateCustomerVisibleName(metadata.getBaseExceptionName(), "metadata-derived exception name");
        this.validateCustomerVisibleName(metadata.getBaseRequestName(), "metadata-derived request name");
        this.validateCustomerVisibleName(metadata.getBaseResponseName(), "metadata-derived response name");
        trimmedModel.getOperations().values().forEach(operation -> this.validateCustomerVisibleName(operation.getOperationName(), "operations"));
        trimmedModel.getWaiters().forEach((name, waiter) -> this.validateCustomerVisibleName((String)name, "waiters"));
        trimmedModel.getShapes().values().forEach(shape -> {
            String shapeName = shape.getShapeName();
            this.validateCustomerVisibleName(shapeName, "shapes");
            shape.getMembers().forEach(member -> {
                this.validateCustomerVisibleName(member.getFluentGetterMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getFluentSetterMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getFluentEnumGetterMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getFluentEnumSetterMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getExistenceCheckMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getBeanStyleGetterMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getBeanStyleSetterMethodName(), shapeName + " shape");
                this.validateCustomerVisibleName(member.getEnumType(), shapeName + " shape");
            });
        });
    }

    private void validateCustomerVisibleName(String name, String location) {
        if (name == null) {
            return;
        }
        if (name.contains("_")) {
            UnderscoresInNameBehavior behavior = this.customizationConfig.getUnderscoresInNameBehavior();
            String supportedBehaviors = Arrays.toString((Object[])UnderscoresInNameBehavior.values());
            Validate.notNull((Object)((Object)behavior), (String)"Encountered a name or identifier that the customer will see (%s in the %s) with an underscore. This isn't idiomatic in Java. Please either remove the underscores or apply the 'underscoresInNameBehavior' customization for this service (Supported 'underscoresInNameBehavior' values: %s).", (Object[])new Object[]{name, location, supportedBehaviors});
            Validate.isTrue((behavior == UnderscoresInNameBehavior.ALLOW ? 1 : 0) != 0, (String)"Unsupported underscoresInShapeNameBehavior: %s. Supported values: %s", (Object[])new Object[]{behavior, supportedBehaviors});
        }
        Validate.isTrue((boolean)VALID_IDENTIFIER_NAME.matcher(name).matches(), (String)"Encountered a name or identifier that is invalid within Java (%s in %s). Please remove invalid characters.", (Object[])new Object[]{name, location});
    }

    static {
        HashSet reservedJavaKeywords = new HashSet();
        Collections.addAll(reservedJavaKeywords, "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
        RESERVED_KEYWORDS = Collections.unmodifiableSet(reservedJavaKeywords);
        HashSet reservedJavaMethodNames = new HashSet();
        Collections.addAll(reservedJavaMethodNames, "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait");
        HashSet reserveJavaPojoMethodNames = new HashSet(reservedJavaMethodNames);
        Collections.addAll(reserveJavaPojoMethodNames, "builder", "sdkFields", "toBuilder");
        HashSet reservedExceptionMethodNames = new HashSet(reserveJavaPojoMethodNames);
        Collections.addAll(reservedExceptionMethodNames, "awsErrorDetails", "cause", "fillInStackTrace", "getCause", "getLocalizedMessage", "getMessage", "getStackTrace", "getSuppressed", "isClockSkewException", "isThrottlingException", "printStackTrace", "requestId", "retryable", "serializableBuilderClass", "statusCode");
        RESERVED_EXCEPTION_METHOD_NAMES = Collections.unmodifiableSet(reservedExceptionMethodNames);
        HashSet reservedStructureMethodNames = new HashSet(reserveJavaPojoMethodNames);
        Collections.addAll(reservedStructureMethodNames, "overrideConfiguration", "sdkHttpResponse");
        RESERVED_STRUCTURE_METHOD_NAMES = Collections.unmodifiableSet(reservedStructureMethodNames);
    }
}

