/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.Collections;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.config.customization.MetadataConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.service.ServiceMetadata;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

public class MetadataModifiersProcessor
implements CodegenCustomizationProcessor {
    private final MetadataConfig metadataConfig;

    MetadataModifiersProcessor(MetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.metadataConfig == null) {
            return;
        }
        ServiceMetadata serviceMetadata = serviceModel.getMetadata();
        String customProtocol = this.metadataConfig.getProtocol();
        if (customProtocol != null) {
            serviceMetadata.setProtocols(Collections.singletonList(customProtocol));
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.metadataConfig == null) {
            return;
        }
        Metadata metadata = intermediateModel.getMetadata();
        String contentType = this.metadataConfig.getContentType();
        if (contentType != null) {
            metadata.setContentType(contentType);
        }
    }
}

