/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.rules2.AssignIdentifierVisitor;
import software.amazon.awssdk.codegen.poet.rules2.AssignTypesVisitor;
import software.amazon.awssdk.codegen.poet.rules2.ComputeScopeTree;
import software.amazon.awssdk.codegen.poet.rules2.PrepareForCodegenVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RenameForCodegenVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;

public final class CodegenExpressionBuidler {
    private final RuleSetExpression root;
    private final SymbolTable symbolTable;
    private final Map<String, ComputeScopeTree.Scope> scopesByName;

    public CodegenExpressionBuidler(RuleSetExpression root, SymbolTable symbolTable, Map<String, ComputeScopeTree.Scope> scopesByName) {
        this.root = root;
        this.symbolTable = symbolTable;
        this.scopesByName = scopesByName;
    }

    public static CodegenExpressionBuidler from(RuleSetExpression root, RuleRuntimeTypeMirror typeMirror, SymbolTable table) {
        AssignTypesVisitor assignTypesVisitor = new AssignTypesVisitor(typeMirror, table);
        root = (RuleSetExpression)root.accept(assignTypesVisitor);
        List<String> errors = assignTypesVisitor.errors();
        if (!errors.isEmpty()) {
            throw new RuntimeException("Errors found while parsing the endpoint rules: " + String.join((CharSequence)", ", errors));
        }
        table = assignTypesVisitor.symbolTable();
        root = CodegenExpressionBuidler.assignIdentifier(root);
        RenameForCodegenVisitor renameForCodegenVisitor = new RenameForCodegenVisitor(table);
        root = (RuleSetExpression)root.accept(renameForCodegenVisitor);
        table = renameForCodegenVisitor.symbolTable();
        ComputeScopeTree computeScopeTree = new ComputeScopeTree(table);
        root.accept(computeScopeTree);
        PrepareForCodegenVisitor prepareForCodegenVisitor = new PrepareForCodegenVisitor();
        RuleSetExpression newRoot = (RuleSetExpression)root.accept(prepareForCodegenVisitor);
        return new CodegenExpressionBuidler(newRoot, table, computeScopeTree.scopesByName());
    }

    private static RuleSetExpression assignIdentifier(RuleSetExpression root) {
        AssignIdentifierVisitor assignIdentifierVisitor = new AssignIdentifierVisitor();
        return (RuleSetExpression)root.accept(assignIdentifierVisitor);
    }

    public RuleSetExpression root() {
        return this.root;
    }

    public String regionParamName() {
        return this.symbolTable.regionParamName();
    }

    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    public Map<String, ComputeScopeTree.Scope> scopesByName() {
        return this.scopesByName;
    }
}

