/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

public class LowercaseShapeValidatorProcessor
implements CodegenCustomizationProcessor {
    @Override
    public void preprocess(ServiceModel serviceModel) {
        serviceModel.getShapes().forEach((shapeName, shape) -> {
            if ("structure".equals(shape.getType()) && Character.isLowerCase(shapeName.charAt(0))) {
                throw new IllegalStateException(String.format("Shape name '%s' starts with a lowercase character.Shape names must start with an uppercase character.Please update the shape name in your service model", shapeName));
            }
        });
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }
}

