/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthSchemeParamsSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public AuthSchemeParamsSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public ClassName className() {
        return this.authSchemeSpecUtils.parametersInterfaceName();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createInterfaceBuilder(this.className()).addSuperinterface(this.toCopyableBuilderInterface()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(SdkPublicApi.class).addJavadoc(this.interfaceJavadoc()).addMethod(this.builderMethod()).addType(this.builderInterfaceSpec());
        this.addAccessorMethods(b);
        this.addToBuilder(b);
        return b.build();
    }

    private CodeBlock interfaceJavadoc() {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("The parameters object used to resolve the auth schemes for the $N service.", new Object[]{this.intermediateModel.getMetadata().getServiceName()});
        return b.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addStatement("return $T.builder()", new Object[]{this.authSchemeSpecUtils.parametersDefaultImplName()}).addJavadoc("Get a new builder for creating a {@link $T}.", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()}).build();
    }

    private TypeSpec builderInterfaceSpec() {
        TypeSpec.Builder b = TypeSpec.interfaceBuilder((ClassName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addSuperinterface(this.copyableBuilderInterface()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("A builder for a {@link $T}.", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()});
        this.addBuilderSetterMethods(b);
        b.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.className()).addJavadoc("Returns a {@link $T} object that is created from the properties that have been set on the builder.", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()}).build());
        return b.build();
    }

    private void addAccessorMethods(TypeSpec.Builder b) {
        b.addMethod(MethodSpec.methodBuilder((String)"operation").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class).addJavadoc("Returns the operation for which to resolve the auth scheme.", new Object[0]).build());
        if (this.authSchemeSpecUtils.usesSigV4()) {
            b.addMethod(MethodSpec.methodBuilder((String)"region").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Region.class).addJavadoc("Returns the region. The region parameter may be used with the $S auth scheme.", new Object[]{"aws.auth#sigv4"}).build());
        }
        if (this.authSchemeSpecUtils.hasSigV4aSupport()) {
            b.addMethod(MethodSpec.methodBuilder((String)"regionSet").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(RegionSet.class).addJavadoc("Returns the RegionSet. The regionSet parameter may be used with the $S auth scheme.", new Object[]{"aws.auth#sigv4a"}).build());
        }
        if (this.authSchemeSpecUtils.generateEndpointBasedParams()) {
            this.parameters().forEach((name, model) -> {
                if (this.authSchemeSpecUtils.includeParam((String)name)) {
                    MethodSpec accessor = this.endpointRulesSpecUtils.parameterInterfaceAccessorMethod((String)name, (ParameterModel)model);
                    if (model.getDocumentation() != null) {
                        accessor = accessor.toBuilder().addJavadoc(model.getDocumentation(), new Object[0]).build();
                    }
                    b.addMethod(accessor);
                }
            });
        }
    }

    private void addToBuilder(TypeSpec.Builder b) {
        ClassName builderClassName = this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName();
        b.addMethod(MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)builderClassName).addJavadoc("Returns a {@link $T} to customize the parameters.", new Object[]{builderClassName}).build());
    }

    private void addBuilderSetterMethods(TypeSpec.Builder b) {
        b.addMethod(MethodSpec.methodBuilder((String)"operation").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)"operation", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addJavadoc("Set the operation for which to resolve the auth scheme.", new Object[0]).build());
        if (this.authSchemeSpecUtils.usesSigV4()) {
            b.addMethod(MethodSpec.methodBuilder((String)"region").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(Region.class, (String)"region", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addJavadoc("Set the region. The region parameter may be used with the $S auth scheme.", new Object[]{"aws.auth#sigv4"}).build());
        }
        if (this.authSchemeSpecUtils.hasSigV4aSupport()) {
            b.addMethod(MethodSpec.methodBuilder((String)"regionSet").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(RegionSet.class, (String)"regionSet", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceBuilderInterfaceName()).addJavadoc("Set the RegionSet. The regionSet parameter may be used with the $S auth scheme.", new Object[]{"aws.auth#sigv4a"}).build());
        }
        if (this.authSchemeSpecUtils.generateEndpointBasedParams()) {
            this.parameters().forEach((name, model) -> {
                if (this.authSchemeSpecUtils.includeParam((String)name)) {
                    ClassName parametersInterfaceName = this.authSchemeSpecUtils.parametersInterfaceName();
                    MethodSpec setter = this.endpointRulesSpecUtils.parameterBuilderSetterMethodDeclaration(parametersInterfaceName, (String)name, (ParameterModel)model);
                    if (model.getDocumentation() != null) {
                        setter = setter.toBuilder().addJavadoc(model.getDocumentation(), new Object[0]).build();
                    }
                    b.addMethod(setter);
                }
            });
        }
    }

    private Map<String, ParameterModel> parameters() {
        return this.intermediateModel.getEndpointRuleSetModel().getParameters();
    }

    private TypeName toCopyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ToCopyableBuilder.class), (TypeName[])new TypeName[]{this.className().nestedClass("Builder"), this.className()});
    }

    private TypeName copyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CopyableBuilder.class), (TypeName[])new TypeName[]{this.className().nestedClass("Builder"), this.className()});
    }
}

