/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.codegen.poet.rules2.BooleanAndExpression;
import software.amazon.awssdk.codegen.poet.rules2.BooleanNotExpression;
import software.amazon.awssdk.codegen.poet.rules2.EndpointExpression;
import software.amazon.awssdk.codegen.poet.rules2.ErrorExpression;
import software.amazon.awssdk.codegen.poet.rules2.FunctionCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.HeadersExpression;
import software.amazon.awssdk.codegen.poet.rules2.IndexedAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.ListExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralBooleanExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralIntegerExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralStringExpression;
import software.amazon.awssdk.codegen.poet.rules2.MemberAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.MethodCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.PropertiesExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.StringConcatExpression;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.utils.Validate;

public class RewriteRuleExpressionVisitor
implements RuleExpressionVisitor<RuleExpression> {
    @Override
    public RuleExpression visitLiteralBooleanExpression(LiteralBooleanExpression expr) {
        return expr;
    }

    @Override
    public RuleExpression visitLiteralIntegerExpression(LiteralIntegerExpression expr) {
        return expr;
    }

    @Override
    public RuleExpression visitLiteralStringExpression(LiteralStringExpression expr) {
        return expr;
    }

    @Override
    public RuleExpression visitFunctionCallExpression(FunctionCallExpression e) {
        FunctionCallExpression.Builder builder = FunctionCallExpression.builder().name(e.name()).type(e.type());
        for (RuleExpression arg : e.arguments()) {
            builder.addArgument(arg.accept(this));
        }
        return builder.build();
    }

    @Override
    public RuleExpression visitMethodCallExpression(MethodCallExpression e) {
        MethodCallExpression.Builder builder = MethodCallExpression.builder().source(e.source().accept(this)).name(e.name());
        for (RuleExpression arg : e.arguments()) {
            builder.addArgument(arg.accept(this));
        }
        return builder.build();
    }

    @Override
    public RuleExpression visitVariableReferenceExpression(VariableReferenceExpression e) {
        return e;
    }

    @Override
    public RuleExpression visitMemberAccessExpression(MemberAccessExpression e) {
        MemberAccessExpression.Builder builder = MemberAccessExpression.builder().name(e.name()).type(e.type()).directIndex(e.directIndex()).source(e.source().accept(this));
        return builder.build();
    }

    @Override
    public RuleExpression visitIndexedAccessExpression(IndexedAccessExpression e) {
        IndexedAccessExpression.Builder builder = IndexedAccessExpression.builder().index(e.index()).type(e.type()).source(e.source().accept(this));
        return builder.build();
    }

    @Override
    public RuleExpression visitStringConcatExpression(StringConcatExpression e) {
        StringConcatExpression.Builder builder = StringConcatExpression.builder();
        this.visitAllWith(e.expressions(), builder::addExpression);
        return builder.build();
    }

    @Override
    public RuleExpression visitLetExpression(LetExpression e) {
        LetExpression.Builder builder = LetExpression.builder();
        e.bindings().forEach((k, v) -> builder.putBinding((String)k, v.accept(this)));
        return builder.build();
    }

    @Override
    public RuleExpression visitBooleanAndExpression(BooleanAndExpression e) {
        BooleanAndExpression.Builder builder = BooleanAndExpression.builder();
        this.visitAllWith(e.expressions(), builder::addExpression);
        return builder.build();
    }

    @Override
    public RuleExpression visitBooleanNotExpression(BooleanNotExpression e) {
        BooleanNotExpression.Builder builder = BooleanNotExpression.builder();
        builder.expression(e.expression().accept(this));
        return builder.build();
    }

    @Override
    public RuleExpression visitRuleSetExpression(RuleSetExpression e) {
        ErrorExpression error;
        EndpointExpression endpoint;
        RuleSetExpression.Builder builder = e.toBuilder();
        builder.clearConditions();
        this.visitAllWith(e.conditions(), builder::addCondition);
        List<RuleSetExpression> children = e.children();
        if (children != null) {
            builder.clearChildren();
            this.visitAllWith(children, child -> builder.addChildren((RuleSetExpression)Validate.isInstanceOf(RuleSetExpression.class, (Object)child, (String)"expected RuleSetExpression", (Object[])new Object[0])));
        }
        if ((endpoint = e.endpoint()) != null) {
            builder.endpoint((EndpointExpression)Validate.isInstanceOf(EndpointExpression.class, (Object)endpoint.accept(this), (String)"expected EndpointExpression", (Object[])new Object[0]));
        }
        if ((error = e.error()) != null) {
            builder.error((ErrorExpression)Validate.isInstanceOf(ErrorExpression.class, (Object)error.accept(this), (String)"expected ErrorExpression", (Object[])new Object[0]));
        }
        return builder.build();
    }

    @Override
    public RuleExpression visitEndpointExpression(EndpointExpression e) {
        EndpointExpression.Builder builder = EndpointExpression.builder().url(e.url().accept(this)).headers((HeadersExpression)Validate.isInstanceOf(HeadersExpression.class, (Object)e.headers().accept(this), (String)"expected HeadersExpression", (Object[])new Object[0])).properties((PropertiesExpression)Validate.isInstanceOf(PropertiesExpression.class, (Object)e.properties().accept(this), (String)"expected PropertiesExpression", (Object[])new Object[0]));
        return builder.build();
    }

    @Override
    public RuleExpression visitErrorExpression(ErrorExpression e) {
        return new ErrorExpression(e.error().accept(this));
    }

    @Override
    public RuleExpression visitPropertiesExpression(PropertiesExpression e) {
        PropertiesExpression.Builder builder = PropertiesExpression.builder();
        e.properties().forEach((k, v) -> builder.putProperty((String)k, v.accept(this)));
        return builder.build();
    }

    @Override
    public RuleExpression visitHeadersExpression(HeadersExpression e) {
        HeadersExpression.Builder builder = HeadersExpression.builder();
        e.headers().forEach((k, v) -> builder.putHeader((String)k, (ListExpression)v.accept(this)));
        return builder.build();
    }

    @Override
    public RuleExpression visitListExpression(ListExpression e) {
        ListExpression.Builder builder = ListExpression.builder();
        this.visitAllWith(e.expressions(), builder::addExpression);
        return builder.build();
    }

    protected List<RuleExpression> visitAll(List<RuleExpression> expressions) {
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RuleExpression> result = new ArrayList<RuleExpression>();
        this.visitAllWith(expressions, result::add);
        return result;
    }

    protected void visitAllWith(List<? extends RuleExpression> expressions, Consumer<RuleExpression> consumer) {
        for (RuleExpression ruleExpression : expressions) {
            consumer.accept(ruleExpression.accept(this));
        }
    }
}

