/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.emitters.tasks.JmesPathRuntimeGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.WaitersRuntimeGeneratorTask;
import software.amazon.awssdk.codegen.poet.waiters.AsyncWaiterClassSpec;
import software.amazon.awssdk.codegen.poet.waiters.AsyncWaiterInterfaceSpec;
import software.amazon.awssdk.codegen.poet.waiters.WaiterClassSpec;
import software.amazon.awssdk.codegen.poet.waiters.WaiterInterfaceSpec;

@SdkInternalApi
public class WaitersGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public WaitersGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected boolean hasTasks() {
        return this.model.hasWaiters();
    }

    @Override
    protected List<GeneratorTask> createTasks() {
        ArrayList<GeneratorTask> generatorTasks = new ArrayList<GeneratorTask>();
        generatorTasks.addAll(this.createSyncTasks());
        generatorTasks.addAll(this.createAsyncTasks());
        generatorTasks.add(new WaitersRuntimeGeneratorTask(this.generatorTaskParams));
        generatorTasks.add(new JmesPathRuntimeGeneratorTask(this.generatorTaskParams));
        return generatorTasks;
    }

    private List<GeneratorTask> createSyncTasks() {
        ArrayList<GeneratorTask> syncTasks = new ArrayList<GeneratorTask>();
        syncTasks.add(new PoetGeneratorTask(this.waitersClassDir(), this.model.getFileHeader(), new WaiterInterfaceSpec(this.model)));
        syncTasks.add(new PoetGeneratorTask(this.waitersClassDir(), this.model.getFileHeader(), new WaiterClassSpec(this.model)));
        return syncTasks;
    }

    private List<GeneratorTask> createAsyncTasks() {
        ArrayList<GeneratorTask> asyncTasks = new ArrayList<GeneratorTask>();
        asyncTasks.add(new PoetGeneratorTask(this.waitersClassDir(), this.model.getFileHeader(), new AsyncWaiterInterfaceSpec(this.model)));
        asyncTasks.add(new PoetGeneratorTask(this.waitersClassDir(), this.model.getFileHeader(), new AsyncWaiterClassSpec(this.model)));
        return asyncTasks;
    }

    private String waitersClassDir() {
        return this.generatorTaskParams.getPathProvider().getWaitersDirectory();
    }
}

