/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class PropertiesExpression
implements RuleExpression {
    private static final PropertiesExpression EMPTY = new PropertiesExpression(Collections.emptyMap());
    private final RuleType type = RuleRuntimeTypeMirror.VOID;
    private final Map<String, RuleExpression> properties;

    PropertiesExpression(Map<String, RuleExpression> properties) {
        this.properties = Collections.unmodifiableMap(new LinkedHashMap((Map)Validate.paramNotNull(properties, (String)"properties")));
    }

    PropertiesExpression(Builder builder) {
        this(builder.properties);
    }

    public static PropertiesExpression empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.PROPERTIES;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("{:type :properties");
        this.properties.forEach((k, v) -> {
            buf.append(", :").append((String)k).append(" ");
            v.appendTo(buf);
        });
        buf.append("}");
        return buf;
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitPropertiesExpression(this);
    }

    public Map<String, RuleExpression> properties() {
        return this.properties;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesExpression that = (PropertiesExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    public static class Builder {
        private final Map<String, RuleExpression> properties = new LinkedHashMap<String, RuleExpression>();

        public Builder putProperty(String name, RuleExpression expr) {
            this.properties.put((String)Validate.paramNotNull((Object)name, (String)"name"), (RuleExpression)Validate.paramNotNull((Object)expr, (String)"expr"));
            return this;
        }

        public PropertiesExpression build() {
            if (this.properties.isEmpty()) {
                return EMPTY;
            }
            return new PropertiesExpression(this);
        }
    }
}

