/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;

public class QueryProtocolSpec
implements ProtocolSpec {
    protected final PoetExtensions poetExtensions;

    public QueryProtocolSpec(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    protected Class<?> protocolFactoryClass() {
        return AwsQueryProtocolFactory.class;
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns(this.protocolFactoryClass()).addModifiers(new Modifier[]{Modifier.PRIVATE});
        methodSpec.addCode("return $T.builder()\n", new Object[]{this.protocolFactoryClass()});
        this.registerModeledExceptions(model, this.poetExtensions).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(".clientConfiguration(clientConfiguration)\n.defaultServiceExceptionSupplier($T::builder)\n", new Object[]{this.poetExtensions.getModelClass(model.getSdkModeledExceptionBaseClassName())});
        methodSpec.addCode(".build();", new Object[0]);
        return methodSpec.build();
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = protocolFactory.createResponseHandler($T::builder)", new Object[]{HttpResponseHandler.class, responseType, responseType}).build();
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        return CodeBlock.builder().add("\n\n$T errorResponseHandler = protocolFactory.createErrorResponseHandler();", new Object[]{ParameterizedTypeName.get(HttpResponseHandler.class, (Type[])new Type[]{AwsServiceException.class})}).build();
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>().withOperationName(\"$N\")\n.withResponseHandler($N).withErrorResponseHandler($N)" + this.hostPrefixExpression(opModel) + this.discoveredEndpoint(opModel) + ".withInput($L)", new Object[]{ClientExecutionParams.class, requestType, responseType, opModel.getOperationName(), "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()});
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withRequestBody(requestBody)", new Object[0]).add(".withMarshaller(new $T(new $T(protocolFactory), requestBody)));", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(StreamingRequestMarshaller.class), (TypeName[])new TypeName[]{requestType}), marshaller}).build();
        }
        return codeBlock.add(".withMarshaller(new $T(protocolFactory)) $L);", new Object[]{marshaller, opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestBody = opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
        return CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withOperationName(\"$N\")\n.withMarshaller(new $T(protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler($N)\n" + this.hostPrefixExpression(opModel) + asyncRequestBody + ".withInput($L) $L);", new Object[]{ClientExecutionParams.class, requestType, pojoResponseType, opModel.getOperationName(), marshaller, "errorResponseHandler", opModel.getInput().getVariableName(), opModel.hasStreamingOutput() ? ", asyncResponseTransformer" : ""}).build();
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        return Optional.empty();
    }
}

