/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.identity.SdkIdentityProperty;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.util.MetricUtils;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.identity.spi.ResolveIdentityRequest;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public final class AuthSchemeInterceptorSpec
implements ClassSpec {
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public AuthSchemeInterceptorSpec(IntermediateModel intermediateModel) {
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public ClassName className() {
        return this.authSchemeSpecUtils.authSchemeInterceptor();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addSuperinterface(ExecutionInterceptor.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class);
        builder.addField(FieldSpec.builder(Logger.class, (String)"LOG", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer("$T.loggerFor($T.class)", new Object[]{Logger.class, this.className()}).build());
        builder.addMethod(this.generateBeforeExecution()).addMethod(this.generateResolveAuthOptions()).addMethod(this.generateSelectAuthScheme()).addMethod(this.generateAuthSchemeParams()).addMethod(this.generateTrySelectAuthScheme()).addMethod(this.generateGetIdentityMetric()).addMethod(this.putSelectedAuthSchemeMethodSpec());
        return builder.build();
    }

    private MethodSpec generateBeforeExecution() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"beforeExecution").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Context.BeforeExecution.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        builder.addStatement("$T authOptions = resolveAuthOptions(context, executionAttributes)", new Object[]{this.listOf(AuthSchemeOption.class)}).addStatement("$T selectedAuthScheme = selectAuthScheme(authOptions, executionAttributes)", new Object[]{this.wildcardSelectedAuthScheme()}).addStatement("putSelectedAuthScheme(executionAttributes, selectedAuthScheme)", new Object[0]);
        return builder.build();
    }

    private MethodSpec generateResolveAuthOptions() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"resolveAuthOptions").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(this.listOf(AuthSchemeOption.class)).addParameter(Context.BeforeExecution.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        builder.addStatement("$1T authSchemeProvider = $2T.isInstanceOf($1T.class, executionAttributes.getAttribute($3T.AUTH_SCHEME_RESOLVER), $4S)", new Object[]{this.authSchemeSpecUtils.providerInterfaceName(), Validate.class, SdkInternalExecutionAttribute.class, "Expected an instance of " + this.authSchemeSpecUtils.providerInterfaceName().simpleName()});
        builder.addStatement("$T params = authSchemeParams(context.request(), executionAttributes)", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()});
        builder.addStatement("return authSchemeProvider.resolveAuthScheme(params)", new Object[0]);
        return builder.build();
    }

    private MethodSpec generateAuthSchemeParams() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"authSchemeParams").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.authSchemeSpecUtils.parametersInterfaceName()).addParameter(SdkRequest.class, "request", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        if (!this.authSchemeSpecUtils.useEndpointBasedAuthProvider()) {
            builder.addStatement("$T operation = executionAttributes.getAttribute($T.OPERATION_NAME)", new Object[]{String.class, SdkExecutionAttribute.class});
            if (this.authSchemeSpecUtils.usesSigV4()) {
                builder.addStatement("$T region = executionAttributes.getAttribute($T.AWS_REGION)", new Object[]{Region.class, AwsExecutionAttribute.class});
                builder.addStatement("return $T.builder().operation(operation).region(region).build()", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()});
            } else {
                builder.addStatement("return $T.builder().operation(operation).build()", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()});
            }
            return builder.build();
        }
        builder.addStatement("$T endpointParams = $T.ruleParams(request, executionAttributes)", new Object[]{this.endpointRulesSpecUtils.parametersClassName(), this.endpointRulesSpecUtils.resolverInterceptorName()});
        builder.addStatement("$1T.Builder builder = $1T.builder()", new Object[]{this.authSchemeSpecUtils.parametersInterfaceName()});
        boolean regionIncluded = false;
        for (String paramName : this.endpointRulesSpecUtils.parameters().keySet()) {
            if (!this.authSchemeSpecUtils.includeParamForProvider(paramName)) continue;
            regionIncluded = regionIncluded || paramName.equalsIgnoreCase("region");
            String methodName = this.endpointRulesSpecUtils.paramMethodName(paramName);
            builder.addStatement("builder.$1N(endpointParams.$1N())", new Object[]{methodName});
        }
        builder.addStatement("$T operation = executionAttributes.getAttribute($T.OPERATION_NAME)", new Object[]{String.class, SdkExecutionAttribute.class});
        builder.addStatement("builder.operation(operation)", new Object[0]);
        if (this.authSchemeSpecUtils.usesSigV4() && !regionIncluded) {
            builder.addStatement("$T region = executionAttributes.getAttribute($T.AWS_REGION)", new Object[]{Region.class, AwsExecutionAttribute.class});
            builder.addStatement("builder.region(region)", new Object[0]);
        }
        ClassName paramsBuilderClass = this.authSchemeSpecUtils.parametersEndpointAwareDefaultImplName().nestedClass("Builder");
        builder.beginControlFlow("if (builder instanceof $T)", new Object[]{paramsBuilderClass});
        ClassName endpointProviderClass = this.endpointRulesSpecUtils.providerInterfaceName();
        builder.addStatement("$T endpointProvider = executionAttributes.getAttribute($T.ENDPOINT_PROVIDER)", new Object[]{EndpointProvider.class, SdkInternalExecutionAttribute.class});
        builder.beginControlFlow("if (endpointProvider instanceof $T)", new Object[]{endpointProviderClass});
        builder.addStatement("(($T)builder).endpointProvider(($T)endpointProvider)", new Object[]{paramsBuilderClass, endpointProviderClass});
        builder.endControlFlow();
        builder.endControlFlow();
        builder.addStatement("return builder.build()", new Object[0]);
        return builder.build();
    }

    private MethodSpec generateSelectAuthScheme() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"selectAuthScheme").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(this.wildcardSelectedAuthScheme()).addParameter(this.listOf(AuthSchemeOption.class), "authOptions", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        builder.addStatement("$T metricCollector = executionAttributes.getAttribute($T.API_CALL_METRIC_COLLECTOR)", new Object[]{MetricCollector.class, SdkExecutionAttribute.class}).addStatement("$T authSchemes = executionAttributes.getAttribute($T.AUTH_SCHEMES)", new Object[]{this.mapOf(String.class, this.wildcardAuthScheme()), SdkInternalExecutionAttribute.class}).addStatement("$T identityProviders = executionAttributes.getAttribute($T.IDENTITY_PROVIDERS)", new Object[]{IdentityProviders.class, SdkInternalExecutionAttribute.class}).addStatement("$T discardedReasons = new $T<>()", new Object[]{this.listOfStringSuppliers(), ArrayList.class});
        builder.beginControlFlow("for ($T authOption : authOptions)", new Object[]{AuthSchemeOption.class});
        builder.addStatement("$T authScheme = authSchemes.get(authOption.schemeId())", new Object[]{this.wildcardAuthScheme()}).addStatement("$T selectedAuthScheme = trySelectAuthScheme(authOption, authScheme, identityProviders, discardedReasons, metricCollector, executionAttributes)", new Object[]{this.wildcardSelectedAuthScheme()});
        builder.beginControlFlow("if (selectedAuthScheme != null)", new Object[0]);
        this.addLogDebugDiscardedOptions(builder);
        builder.addStatement("return selectedAuthScheme", new Object[0]).endControlFlow();
        builder.endControlFlow();
        builder.addStatement("throw $T.builder().message($S + discardedReasons.stream().map($T::get).collect($T.joining(\", \"))).build()", new Object[]{SdkException.class, "Failed to determine how to authenticate the user: ", Supplier.class, Collectors.class});
        return builder.build();
    }

    private MethodSpec generateTrySelectAuthScheme() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"trySelectAuthScheme").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(this.namedSelectedAuthScheme()).addParameter(AuthSchemeOption.class, "authOption", new Modifier[0]).addParameter(this.namedAuthScheme(), "authScheme", new Modifier[0]).addParameter(IdentityProviders.class, "identityProviders", new Modifier[0]).addParameter(this.listOfStringSuppliers(), "discardedReasons", new Modifier[0]).addParameter(MetricCollector.class, "metricCollector", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]).addTypeVariable(TypeVariableName.get((String)"T", (Type[])new Type[]{Identity.class}));
        builder.beginControlFlow("if (authScheme == null)", new Object[0]);
        builder.addStatement("discardedReasons.add(() -> String.format($S, authOption.schemeId()))", new Object[]{"'%s' is not enabled for this request."}).addStatement("return null", new Object[0]).endControlFlow();
        builder.addStatement("$T identityProvider = authScheme.identityProvider(identityProviders)", new Object[]{this.namedIdentityProvider()});
        builder.beginControlFlow("if (identityProvider == null)", new Object[0]);
        builder.addStatement("discardedReasons.add(() -> String.format($S, authOption.schemeId()))", new Object[]{"'%s' does not have an identity provider configured."}).addStatement("return null", new Object[0]).endControlFlow();
        builder.addStatement("$T signer", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(HttpSigner.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})});
        builder.beginControlFlow("try", new Object[0]);
        builder.addStatement("signer = authScheme.signer()", new Object[0]);
        builder.nextControlFlow("catch (RuntimeException e)", new Object[0]);
        builder.addStatement("discardedReasons.add(() -> String.format($S, authOption.schemeId(), e.getMessage()))", new Object[]{"'%s' signer could not be retrieved: %s"}).addStatement("return null", new Object[0]).endControlFlow();
        builder.addStatement("$T.Builder identityRequestBuilder = $T.builder()", new Object[]{ResolveIdentityRequest.class, ResolveIdentityRequest.class});
        builder.addStatement("authOption.forEachIdentityProperty(identityRequestBuilder::putProperty)", new Object[0]);
        if (this.endpointRulesSpecUtils.isS3()) {
            builder.addStatement("identityRequestBuilder.putProperty($T.SDK_CLIENT, executionAttributes.getAttribute($T.SDK_CLIENT))", new Object[]{SdkIdentityProperty.class, SdkInternalExecutionAttribute.class});
        }
        builder.addStatement("$T identity", new Object[]{this.namedIdentityFuture()});
        builder.addStatement("$T metric = getIdentityMetric(identityProvider)", new Object[]{this.durationSdkMetric()});
        builder.beginControlFlow("if (metric == null)", new Object[0]).addStatement("identity = identityProvider.resolveIdentity(identityRequestBuilder.build())", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("identity = $T.reportDuration(() -> identityProvider.resolveIdentity(identityRequestBuilder.build()), metricCollector, metric)", new Object[]{MetricUtils.class}).endControlFlow();
        builder.addStatement("return new $T<>(identity, signer, authOption)", new Object[]{SelectedAuthScheme.class});
        return builder.build();
    }

    private MethodSpec generateGetIdentityMetric() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getIdentityMetric").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.durationSdkMetric()).addParameter(this.wildcardIdentityProvider(), "identityProvider", new Modifier[0]);
        builder.addStatement("Class<?> identityType = identityProvider.identityType()", new Object[0]).beginControlFlow("if (identityType == $T.class)", new Object[]{AwsCredentialsIdentity.class}).addStatement("return $T.CREDENTIALS_FETCH_DURATION", new Object[]{CoreMetric.class}).endControlFlow().beginControlFlow("if (identityType == $T.class)", new Object[]{TokenIdentity.class}).addStatement("return $T.TOKEN_FETCH_DURATION", new Object[]{CoreMetric.class}).endControlFlow().addStatement("return null", new Object[0]);
        return builder.build();
    }

    private MethodSpec putSelectedAuthSchemeMethodSpec() {
        String attributeParamName = "attributes";
        String selectedAuthSchemeParamName = "selectedAuthScheme";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"putSelectedAuthScheme").addModifiers(new Modifier[]{Modifier.PRIVATE}).addTypeVariable(TypeVariableName.get((String)"T", (Type[])new Type[]{Identity.class})).addParameter(ExecutionAttributes.class, attributeParamName, new Modifier[0]).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SelectedAuthScheme.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), (String)selectedAuthSchemeParamName, (Modifier[])new Modifier[0]).build());
        builder.addStatement("$T existingAuthScheme = $N.getAttribute($T.SELECTED_AUTH_SCHEME)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(SelectedAuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), attributeParamName, SdkInternalExecutionAttribute.class});
        builder.beginControlFlow("if (existingAuthScheme != null)", new Object[0]).addStatement("$T selectedOption = $N.authSchemeOption().toBuilder()", new Object[]{AuthSchemeOption.Builder.class, selectedAuthSchemeParamName}).addStatement("existingAuthScheme.authSchemeOption().forEachIdentityProperty(selectedOption::putIdentityPropertyIfAbsent)", new Object[0]).addStatement("existingAuthScheme.authSchemeOption().forEachSignerProperty(selectedOption::putSignerPropertyIfAbsent)", new Object[0]).addStatement("$N = new $T<>($N.identity(), $N.signer(), selectedOption.build())", new Object[]{selectedAuthSchemeParamName, SelectedAuthScheme.class, selectedAuthSchemeParamName, selectedAuthSchemeParamName});
        builder.endControlFlow();
        builder.addStatement("$N.putAttribute($T.SELECTED_AUTH_SCHEME, $N)", new Object[]{attributeParamName, SdkInternalExecutionAttribute.class, selectedAuthSchemeParamName});
        return builder.build();
    }

    private void addLogDebugDiscardedOptions(MethodSpec.Builder builder) {
        builder.beginControlFlow("if (!discardedReasons.isEmpty())", new Object[0]);
        builder.addStatement("LOG.debug(() -> String.format(\"%s auth will be used, discarded: '%s'\", authOption.schemeId(), discardedReasons.stream().map($T::get).collect($T.joining(\", \"))))", new Object[]{Supplier.class, Collectors.class}).endControlFlow();
    }

    private TypeName namedIdentityProvider() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
    }

    private TypeName wildcardIdentityProvider() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
    }

    private TypeName namedIdentityFuture() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeVariableName.get((String)"T"))});
    }

    private TypeName namedAuthScheme() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T", (Type[])new Type[]{Identity.class})});
    }

    private TypeName wildcardAuthScheme() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
    }

    private TypeName namedSelectedAuthScheme() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(SelectedAuthScheme.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T", (Type[])new Type[]{Identity.class})});
    }

    private TypeName wildcardSelectedAuthScheme() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(SelectedAuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Identity.class)});
    }

    private TypeName listOfStringSuppliers() {
        return this.listOf(ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{String.class}));
    }

    private TypeName mapOf(Object keyType, Object valueType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.toTypeName(keyType), this.toTypeName(valueType)});
    }

    private TypeName listOf(Object valueType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.toTypeName(valueType)});
    }

    private ParameterizedTypeName durationSdkMetric() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(SdkMetric.class), (TypeName[])new TypeName[]{this.toTypeName(Duration.class)});
    }

    private TypeName toTypeName(Object valueType) {
        ClassName result;
        if (valueType instanceof Class) {
            result = ClassName.get((Class)((Class)valueType));
        } else if (valueType instanceof TypeName) {
            result = (TypeName)valueType;
        } else {
            throw new IllegalArgumentException("Don't know how to convert " + valueType + " to TypeName");
        }
        return result;
    }
}

