/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class MethodCallExpression
implements RuleExpression {
    private final RuleType type;
    private final RuleExpression source;
    private final String name;
    private final List<RuleExpression> arguments;

    MethodCallExpression(Builder builder) {
        this.type = builder.type;
        this.source = (RuleExpression)Validate.paramNotNull((Object)builder.source, (String)"source");
        this.name = (String)Validate.paramNotNull((Object)builder.name, (String)"name");
        this.arguments = Collections.unmodifiableList(new ArrayList(builder.arguments));
    }

    public static Builder builder() {
        return new Builder();
    }

    public RuleExpression source() {
        return this.source;
    }

    public String name() {
        return this.name;
    }

    public List<RuleExpression> arguments() {
        return this.arguments;
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.METHOD_CALL;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("(.").append(this.name).append(" ");
        this.source.appendTo(buf);
        for (RuleExpression expr : this.arguments) {
            buf.append(" ");
            expr.appendTo(buf);
        }
        buf.append(")");
        return buf;
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitMethodCallExpression(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodCallExpression that = (MethodCallExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public static class Builder {
        private final List<RuleExpression> arguments = new ArrayList<RuleExpression>();
        private RuleType type;
        private RuleExpression source;
        private String name;

        public Builder() {
        }

        public Builder(MethodCallExpression expr) {
            this.type = expr.type;
            this.name = expr.name;
            this.source = expr.source;
            this.arguments.addAll(expr.arguments);
        }

        public Builder type(RuleType type) {
            this.type = type;
            return this;
        }

        public Builder source(RuleExpression source) {
            this.source = source;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addArgument(RuleExpression arg) {
            this.arguments.add(arg);
            return this;
        }

        public MethodCallExpression build() {
            return new MethodCallExpression(this);
        }
    }
}

