/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;

public final class DocumentationUtils {
    private static final String DEFAULT_SETTER = "Sets the value of the %s property for this object.";
    private static final String DEFAULT_SETTER_PARAM = "The new value for the %s property for this object.";
    private static final String DEFAULT_GETTER = "Returns the value of the %s property for this object.";
    private static final String DEFAULT_GETTER_PARAM = "The value of the %s property for this object.";
    private static final String DEFAULT_EXISTENCE_CHECK = "For responses, this returns true if the service returned a value for the %s property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return a null collection or map, but you may need to differentiate between the service returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true if a value for the property was specified in the request builder, and false if a value was not specified.";
    private static final String DEFAULT_FLUENT_RETURN = "Returns a reference to this object so that method calls can be chained together.";
    private static final Set<String> SERVICES_EXCLUDED_FROM_CROSS_LINKING = new HashSet<String>(Arrays.asList("apigateway", "budgets", "cloudsearch", "cloudsearchdomain", "discovery", "elastictranscoder", "es", "glacier", "iot", "data.iot", "machinelearning", "rekognition", "s3", "sdb", "swf"));

    private DocumentationUtils() {
    }

    public static String stripHtmlTags(String documentation) {
        if (documentation == null) {
            return "";
        }
        if (documentation.startsWith("<")) {
            int startTagIndex = documentation.indexOf(62);
            int closingTagIndex = documentation.lastIndexOf(60);
            documentation = closingTagIndex > startTagIndex ? DocumentationUtils.stripHtmlTags(documentation.substring(startTagIndex + 1, closingTagIndex)) : DocumentationUtils.stripHtmlTags(documentation.substring(startTagIndex + 1));
        }
        return documentation.trim();
    }

    public static String escapeIllegalCharacters(String documentation) {
        if (documentation == null) {
            return "";
        }
        documentation = documentation.replaceAll("\\*\\/", "*&#47;");
        return documentation;
    }

    public static String createLinkToServiceDocumentation(Metadata metadata, String name) {
        if (DocumentationUtils.isCrossLinkingEnabledForService(metadata)) {
            return String.format("<a href=\"https://%s/goto/WebAPI/%s/%s\" target=\"_top\">AWS API Documentation</a>", "docs.aws.amazon.com", metadata.getUid(), name);
        }
        return "";
    }

    public static String createLinkToServiceDocumentation(Metadata metadata, ShapeModel shapeModel) {
        return DocumentationUtils.isRequestResponseOrModel(shapeModel) ? DocumentationUtils.createLinkToServiceDocumentation(metadata, shapeModel.getDocumentationShapeName()) : "";
    }

    public static String removeFromEnd(String string, String stringToRemove) {
        return string.endsWith(stringToRemove) ? string.substring(0, string.length() - stringToRemove.length()) : string;
    }

    private static boolean isRequestResponseOrModel(ShapeModel shapeModel) {
        return shapeModel.getShapeType() == ShapeType.Model || shapeModel.getShapeType() == ShapeType.Request || shapeModel.getShapeType() == ShapeType.Response;
    }

    private static boolean isCrossLinkingEnabledForService(Metadata metadata) {
        return metadata.getUid() != null && metadata.getEndpointPrefix() != null && !SERVICES_EXCLUDED_FROM_CROSS_LINKING.contains(metadata.getEndpointPrefix());
    }

    public static String defaultSetter() {
        return DEFAULT_SETTER;
    }

    public static String defaultSetterParam() {
        return DEFAULT_SETTER_PARAM;
    }

    public static String defaultGetter() {
        return DEFAULT_GETTER;
    }

    public static String defaultGetterParam() {
        return DEFAULT_GETTER_PARAM;
    }

    public static String defaultFluentReturn() {
        return DEFAULT_FLUENT_RETURN;
    }

    public static String defaultExistenceCheck() {
        return DEFAULT_EXISTENCE_CHECK;
    }
}

