/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class RuleFunctionMirror {
    private final String name;
    private final String javaName;
    private final RuleType returns;
    private final RuleType containingType;
    private final Map<String, RuleType> arguments;

    RuleFunctionMirror(Builder builder) {
        this.name = builder.name;
        this.javaName = builder.javaName != null ? builder.javaName : builder.name;
        this.returns = (RuleType)Validate.paramNotNull((Object)builder.returns, (String)"returns");
        this.containingType = (RuleType)Validate.paramNotNull((Object)builder.containingType, (String)"containingType");
        this.arguments = Collections.unmodifiableMap(new LinkedHashMap(builder.arguments));
    }

    public static Builder builder(String name) {
        return new Builder().name(name);
    }

    public String name() {
        return this.name;
    }

    public RuleType returns() {
        return this.returns;
    }

    public RuleType containingType() {
        return this.containingType;
    }

    public String javaName() {
        return this.javaName;
    }

    public Map<String, RuleType> arguments() {
        return this.arguments;
    }

    public boolean matches(List<RuleType> argv) {
        if (argv.size() != this.arguments.size()) {
            return false;
        }
        int idx = 0;
        for (RuleType expected : this.arguments.values()) {
            if (!expected.equals(argv.get(idx))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    static class Builder {
        private final Map<String, RuleType> arguments = new LinkedHashMap<String, RuleType>();
        private String name;
        private String javaName;
        private RuleType returns;
        private RuleType containingType;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder javaName(String javaName) {
            this.javaName = javaName;
            return this;
        }

        public Builder returns(RuleType type) {
            this.returns = type;
            return this;
        }

        public Builder containingType(RuleType containingType) {
            this.containingType = containingType;
            return this;
        }

        public Builder addArgument(String name, RuleType type) {
            this.arguments.put(name, type);
            return this;
        }

        public RuleFunctionMirror build() {
            return new RuleFunctionMirror(this);
        }
    }
}

