/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

public class EndpointBasedAuthSchemeProviderSpec
implements ClassSpec {
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointBasedAuthSchemeProviderSpec(IntermediateModel intermediateModel) {
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public ClassName className() {
        return this.authSchemeSpecUtils.defaultAuthSchemeProviderName();
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)this.authSchemeSpecUtils.providerInterfaceName()).addMethod(this.constructor()).addField(this.defaultInstance()).addField(this.modeledResolverInstance()).addField(this.endpointDelegateInstance()).addMethod(this.createMethod()).addMethod(this.resolveAuthSchemeMethod()).addMethod(this.endpointProvider()).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private FieldSpec defaultInstance() {
        return FieldSpec.builder((TypeName)this.className(), (String)"DEFAULT", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.className()}).build();
    }

    private FieldSpec endpointDelegateInstance() {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.providerInterfaceName(), (String)"DELEGATE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.defaultProvider()", new Object[]{this.endpointRulesSpecUtils.providerInterfaceName()}).build();
    }

    private MethodSpec endpointProvider() {
        ClassName endpointProviderClass = this.endpointRulesSpecUtils.providerInterfaceName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"endpointProvider").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)endpointProviderClass).addParameter((TypeName)this.authSchemeSpecUtils.parametersInterfaceName(), "params", new Modifier[0]);
        ClassName endpointAwareParams = this.authSchemeSpecUtils.parametersEndpointAwareDefaultImplName();
        builder.beginControlFlow("if (params instanceof $T)", new Object[]{endpointAwareParams});
        builder.addStatement("$1T endpointAwareParams = ($1T) params", new Object[]{endpointAwareParams});
        builder.addStatement("$T endpointProvider = endpointAwareParams.endpointProvider()", new Object[]{endpointProviderClass});
        builder.beginControlFlow("if (endpointProvider != null)", new Object[0]);
        builder.addStatement("return endpointProvider", new Object[0]);
        builder.endControlFlow();
        builder.endControlFlow();
        builder.addStatement("return DELEGATE", new Object[0]);
        return builder.build();
    }

    private FieldSpec modeledResolverInstance() {
        return FieldSpec.builder((TypeName)this.authSchemeSpecUtils.providerInterfaceName(), (String)"MODELED_RESOLVER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.create()", new Object[]{this.authSchemeSpecUtils.modeledAuthSchemeProviderName()}).build();
    }

    private MethodSpec createMethod() {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.authSchemeSpecUtils.providerInterfaceName()).addStatement("return DEFAULT", new Object[0]).build();
    }

    private MethodSpec resolveAuthSchemeMethod() {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"resolveAuthScheme").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.authSchemeSpecUtils.resolverReturnType()).addParameter((TypeName)this.authSchemeSpecUtils.parametersInterfaceName(), "params", new Modifier[0]);
        spec.addCode("$1T endpointParameters = $1T.builder()\n$>", new Object[]{this.endpointRulesSpecUtils.parametersClassName()});
        this.parameters().forEach((name, model) -> {
            if (this.authSchemeSpecUtils.includeParamForProvider((String)name)) {
                spec.addCode(".$1L(params.$1L())\n", new Object[]{this.endpointRulesSpecUtils.paramMethodName((String)name)});
            }
        });
        spec.addStatement(".build()", new Object[0]);
        spec.addStatement("$T endpoint = $T.joinLikeSync(endpointProvider(params).resolveEndpoint(endpointParameters))", new Object[]{Endpoint.class, CompletableFutureUtils.class});
        spec.addStatement("$T authSchemes = endpoint.attribute($T.AUTH_SCHEMES)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{EndpointAuthScheme.class}), AwsEndpointAttribute.class});
        spec.beginControlFlow("if (authSchemes == null)", new Object[0]);
        spec.addStatement("return MODELED_RESOLVER.resolveAuthScheme(params)", new Object[0]);
        spec.endControlFlow();
        spec.addStatement("$T options = new $T<>()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{AuthSchemeOption.class}), TypeName.get(ArrayList.class)});
        spec.beginControlFlow("for ($T authScheme : authSchemes)", new Object[]{EndpointAuthScheme.class});
        this.addAuthSchemeSwitch(spec);
        spec.endControlFlow();
        return spec.addStatement("return $T.unmodifiableList(options)", new Object[]{Collections.class}).build();
    }

    private void addAuthSchemeSwitch(MethodSpec.Builder spec) {
        spec.addStatement("$T name = authScheme.name()", new Object[]{String.class});
        spec.beginControlFlow("switch(name)", new Object[0]);
        this.addAuthSchemeSwitchSigV4Case(spec);
        this.addAuthSchemeSwitchSigV4aCase(spec);
        if (this.endpointRulesSpecUtils.useS3Express()) {
            this.addAuthSchemeSwitchS3ExpressCase(spec);
        }
        this.addAuthSchemeSwitchDefaultCase(spec);
        spec.endControlFlow();
    }

    private void addAuthSchemeSwitchSigV4Case(MethodSpec.Builder spec) {
        spec.addCode("case $S:", new Object[]{"sigv4"});
        spec.addStatement("$T sigv4AuthScheme = $T.isInstanceOf($T.class, authScheme, $S, authScheme.getClass().getName())", new Object[]{SigV4AuthScheme.class, Validate.class, SigV4AuthScheme.class, "Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s"});
        spec.addCode("options.add($T.builder().schemeId($S)", new Object[]{AuthSchemeOption.class, "aws.auth#sigv4"}).addCode(".putSignerProperty($T.SERVICE_SIGNING_NAME, sigv4AuthScheme.signingName())", new Object[]{AwsV4HttpSigner.class}).addCode(".putSignerProperty($T.REGION_NAME, sigv4AuthScheme.signingRegion())", new Object[]{AwsV4HttpSigner.class}).addCode(".putSignerProperty($T.DOUBLE_URL_ENCODE, !sigv4AuthScheme.disableDoubleEncoding())", new Object[]{AwsV4HttpSigner.class}).addCode(".build());", new Object[0]);
        spec.addStatement("break", new Object[0]);
    }

    private void addAuthSchemeSwitchSigV4aCase(MethodSpec.Builder spec) {
        spec.addCode("case $S:", new Object[]{"sigv4a"});
        spec.addStatement("$T sigv4aAuthScheme = $T.isInstanceOf($T.class, authScheme, $S, authScheme.getClass().getName())", new Object[]{SigV4aAuthScheme.class, Validate.class, SigV4aAuthScheme.class, "Expecting auth scheme of class SigV4AuthScheme, got instead object of class %s"});
        spec.addStatement("$1T regionSet = $1T.create(sigv4aAuthScheme.signingRegionSet())", new Object[]{RegionSet.class});
        spec.addCode("options.add($T.builder().schemeId($S)", new Object[]{AuthSchemeOption.class, "aws.auth#sigv4a"}).addCode(".putSignerProperty($T.SERVICE_SIGNING_NAME, sigv4aAuthScheme.signingName())", new Object[]{AwsV4aHttpSigner.class}).addCode(".putSignerProperty($T.REGION_SET, regionSet)", new Object[]{AwsV4aHttpSigner.class}).addCode(".putSignerProperty($T.DOUBLE_URL_ENCODE, !sigv4aAuthScheme.disableDoubleEncoding())", new Object[]{AwsV4aHttpSigner.class}).addCode(".build());", new Object[0]);
        spec.addStatement("break", new Object[0]);
    }

    private void addAuthSchemeSwitchS3ExpressCase(MethodSpec.Builder spec) {
        spec.addCode("case $S:", new Object[]{"sigv4-s3express"});
        ClassName s3ExpressEndpointAuthScheme = ClassName.get((String)(this.authSchemeSpecUtils.baseClientPackageName() + ".endpoints.authscheme"), (String)"S3ExpressEndpointAuthScheme", (String[])new String[0]);
        spec.addStatement("$T s3ExpressAuthScheme = $T.isInstanceOf($T.class, authScheme, $S, authScheme.getClass().getName())", new Object[]{s3ExpressEndpointAuthScheme, Validate.class, s3ExpressEndpointAuthScheme, "Expecting auth scheme of class S3ExpressAuthScheme, got instead object of class %s"});
        ClassName s3ExpressAuthScheme = ClassName.get((String)(this.authSchemeSpecUtils.baseClientPackageName() + ".s3express"), (String)"S3ExpressAuthScheme", (String[])new String[0]);
        spec.addCode("options.add($T.builder().schemeId($T.SCHEME_ID)", new Object[]{AuthSchemeOption.class, s3ExpressAuthScheme}).addCode(".putSignerProperty($T.SERVICE_SIGNING_NAME, s3ExpressAuthScheme.signingName())", new Object[]{AwsV4HttpSigner.class}).addCode(".putSignerProperty($T.REGION_NAME, s3ExpressAuthScheme.signingRegion())", new Object[]{AwsV4HttpSigner.class}).addCode(".putSignerProperty($T.DOUBLE_URL_ENCODE, !s3ExpressAuthScheme.disableDoubleEncoding())", new Object[]{AwsV4HttpSigner.class}).addCode(".build());", new Object[0]);
        spec.addStatement("break", new Object[0]);
    }

    private void addAuthSchemeSwitchDefaultCase(MethodSpec.Builder spec) {
        spec.addCode("default:", new Object[0]);
        spec.addStatement("throw new $T($S + name)", new Object[]{IllegalArgumentException.class, "Unknown auth scheme: "});
    }

    private Map<String, ParameterModel> parameters() {
        return this.endpointRulesSpecUtils.parameters();
    }
}

