/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.codegen.IntermediateModelBuilder;
import software.amazon.awssdk.codegen.IntermediateModelShapeProcessor;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.service.Input;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.naming.NamingStrategy;

final class AddEmptyInputShape
implements IntermediateModelShapeProcessor {
    private final ServiceModel serviceModel;
    private final NamingStrategy namingStrategy;

    AddEmptyInputShape(IntermediateModelBuilder builder) {
        this.serviceModel = builder.getService();
        this.namingStrategy = builder.getNamingStrategy();
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        return this.addEmptyInputShapes(currentOperations);
    }

    private Map<String, ShapeModel> addEmptyInputShapes(Map<String, OperationModel> javaOperationMap) {
        Map<String, Operation> operations = this.serviceModel.getOperations();
        HashMap<String, ShapeModel> emptyInputShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : operations.entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Input input = operation.getInput();
            if (input != null) continue;
            String inputShape = this.namingStrategy.getRequestClassName(operationName);
            OperationModel operationModel = javaOperationMap.get(operationName);
            operationModel.setInput(new VariableModel(Utils.unCapitalize(inputShape), inputShape));
            ShapeModel shape = new ShapeModel(inputShape).withType(ShapeType.Request.getValue());
            shape.setShapeName(inputShape);
            VariableModel inputVariable = new VariableModel(this.namingStrategy.getVariableName(inputShape), inputShape);
            shape.setVariable(inputVariable);
            shape.setMarshaller(Utils.createInputShapeMarshaller(this.serviceModel.getMetadata(), operation));
            emptyInputShapes.put(inputShape, shape);
        }
        return emptyInputShapes;
    }
}

